#!/bin/sh
# Iterate through library modules, attempting to start up,
# do some simple commands, save, then restore, then save again,
# and report on the differences.

srcdir=$1

if [ $# -gt 1 ] ; then
	shift
	list=$@
else
	list=`echo $srcdir/../lib/*.g`
fi

if [ -r ../kernel/skelconq ] ; then
	echo "skelconq found"
else
	echo "Error: skelconq not found, exiting"
	exit 1
fi

logname=savetest.log
slogname=svtest.log

/bin/rm -f $logname
/bin/rm -f $slogname
touch $logname
touch $slogname
echo Test started on `date` >> $logname
for i in $list ; do
	echo $i
	echo "" >> $logname
	echo ">>> Running skelconq on: " $i "<<<" >> $logname
	echo "" >> $logname
	echo ">>> Running skelconq on: " $i "<<<" >> $slogname
	../kernel/skelconq -f $i -L $srcdir/../lib <$srcdir/savetst1.inp >> $logname
	if [ -f ~/.xconq/save.xconq ] ; then
		mv ~/.xconq/save.xconq save1.xconq
		echo ">>> Restoring skelconq; <<<" >> $logname
		../kernel/skelconq -f save1.xconq -noai <$srcdir/savetst2.inp >> $logname
		if [ -f ~/.xconq/save.xconq ] ; then
			sed -e '/run-serial-number/d' \
			    -e '/elapsed-real-time/d' \
			    -e '/ai-type-name/d' \
			    -e '/game-saved/d' \
			    -e '/log-started/d' \
			    -e '/game-restarted/d' \
			    save1.xconq >save1f.xconq
			mv ~/.xconq/save.xconq save2.xconq
			sed -e '/run-serial-number/d' \
			    -e '/elapsed-real-time/d' \
			    -e '/ai-type-name/d' \
			    -e '/game-saved/d' \
			    -e '/log-started/d' \
			    -e '/game-restarted/d' \
			    save2.xconq >save2f.xconq
			echo ">>> diff -c save1f.xconq save2f.xconq <<<" >> $logname
			diff -c save1f.xconq save2f.xconq >> $logname
			echo ">>> diff -u0 save1f.xconq save2f.xconq <<<" >> $slogname
			diff -u0 save1f.xconq save2f.xconq | grep -v '^@' >> $slogname
			echo `diff -u0 save1f.xconq save2f.xconq | grep -v '^[0-9]' | wc -l` lines of difference
		else
			echo Second savefile missing!
		fi
	fi
done
echo Test finished on `date` >> $logname
