/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef SNIPES_KEY_DEFS

#define SNIPES_KEY_DEFS


#define RELEASE(n)	(128+n)


#ifdef PPC_LINUX

#define KEYBOARD_KEY_DOWN_C		8
#define KEYBOARD_KEY_DOWN_Z		6
#define KEYBOARD_KEY_DOWN_A		0
#define KEYBOARD_KEY_DOWN_S		1
#define KEYBOARD_KEY_DOWN_D		2
#define KEYBOARD_KEY_DOWN_W		13
#define KEYBOARD_KEY_DOWN_ARR_U		62
#define KEYBOARD_KEY_DOWN_ARR_L		59
#define KEYBOARD_KEY_DOWN_ARR_D 	61
#define KEYBOARD_KEY_DOWN_ARR_R		60
#define KEYBOARD_KEY_DOWN_CTRL	 	54

#define KEYBOARD_KEY_UP_C		RELEASE(8)
#define KEYBOARD_KEY_UP_Z		RELEASE(6)
#define KEYBOARD_KEY_UP_A		RELEASE(0)
#define KEYBOARD_KEY_UP_S		RELEASE(1)
#define KEYBOARD_KEY_UP_D		RELEASE(2)
#define KEYBOARD_KEY_UP_W		RELEASE(13)
#define KEYBOARD_KEY_UP_ARR_U		RELEASE(62)
#define KEYBOARD_KEY_UP_ARR_L		RELEASE(59)
#define KEYBOARD_KEY_UP_ARR_D 		RELEASE(61)
#define KEYBOARD_KEY_UP_ARR_R		RELEASE(60)
#define KEYBOARD_KEY_UP_CTRL	 	RELEASE(54)

#else

#define KEYBOARD_KEY_DOWN_C		46
#define KEYBOARD_KEY_DOWN_Z		44
#define KEYBOARD_KEY_DOWN_A		30
#define KEYBOARD_KEY_DOWN_S		31
#define KEYBOARD_KEY_DOWN_D		32
#define KEYBOARD_KEY_DOWN_W		17
#define KEYBOARD_KEY_DOWN_ARR_U		103
#define KEYBOARD_KEY_DOWN_ARR_L		105
#define KEYBOARD_KEY_DOWN_ARR_D 	108
#define KEYBOARD_KEY_DOWN_ARR_R		106
#define KEYBOARD_KEY_DOWN_CTRL	 	29
#define KEYBOARD_KEY_DOWN_SPACE		57

#define KEYBOARD_KEY_UP_C		RELEASE(46)
#define KEYBOARD_KEY_UP_Z		RELEASE(44)
#define KEYBOARD_KEY_UP_A		RELEASE(30)
#define KEYBOARD_KEY_UP_S		RELEASE(31)
#define KEYBOARD_KEY_UP_D		RELEASE(32)
#define KEYBOARD_KEY_UP_W		RELEASE(17)
#define KEYBOARD_KEY_UP_ARR_U		RELEASE(103)
#define KEYBOARD_KEY_UP_ARR_L		RELEASE(105)
#define KEYBOARD_KEY_UP_ARR_D 		RELEASE(108)
#define KEYBOARD_KEY_UP_ARR_R		RELEASE(106)
#define KEYBOARD_KEY_UP_CTRL	 	RELEASE(29)
#define KEYBOARD_KEY_UP_SPACE		RELEASE(57)

#endif

#endif // SNIPES_KEY_DEFS
