#include <gtk/gtk.h>

#include "guiinterface.h"

#include "../game.h"
#include "../rules.h"

GtkWidget *board_widget = NULL;
GtkWidget *pieces[BOARD_XSIZE][BOARD_YSIZE];

extern int direction[8][2];

/*
struct {
	GdkPixmap *pixmap;
	GdkBitmap *mask;
} pix[2];
*/

/* Called with realized GtkWindow (valid GdkWindow), to create GdkPixmap&Masks.
 * Not sure about how to do this, and unable to even create a decent X/O
 * pixmaps.
 */
void gui_board_init(GtkWidget *window)
{
}

void gui_board_square_set_win(Coordinate *coor, Square s)
{
	gtk_widget_destroy(pieces[coor->xy[0]][coor->xy[1]]);
	pieces[coor->xy[0]][coor->xy[1]] = gtk_label_new((s == 1) ? "o" : "x");
	gtk_widget_show(pieces[coor->xy[0]][coor->xy[1]]);
	gtk_table_attach_defaults(GTK_TABLE(board_widget), pieces[coor->xy[0]][coor->xy[1]], coor->xy[0], coor->xy[0]+1, coor->xy[1], coor->xy[1]+1);
}

void gui_board_show_win(Coordinate *coor)
{
}

void gui_board_show_tie(void)
{
}

GtkWidget *_empty_button_new(void)
{
	GtkWidget *button = gtk_button_new();

	gtk_widget_set_usize(button, BUTTON_BORDER, BUTTON_BORDER);
	gtk_widget_show(button);

	return button;
}

void _cb_square_clicked(GtkWidget *W, int offset)
{
	Coordinate coor = {{offset % BOARD_XSIZE, offset / BOARD_XSIZE}};

	game_square_modify(&coor, PLAYER_HUMAN);
}

GtkWidget *_gui_board_table_new(void)
{
	int x, y;
	GtkWidget *widget;

	widget = gtk_table_new(BOARD_YSIZE, BOARD_XSIZE, TRUE);
	gtk_widget_show(widget);

	for(x=0; x<BOARD_XSIZE; x++)
		for(y=0; y<BOARD_YSIZE; y++) {
			gtk_signal_connect(GTK_OBJECT(pieces[x][y] = _empty_button_new()), "clicked", GTK_SIGNAL_FUNC(_cb_square_clicked), (gpointer)(y*BOARD_XSIZE+x));
			gtk_table_attach_defaults(GTK_TABLE(widget), pieces[x][y], x, x+1, y, y+1);
		}

	return widget;
}

GtkWidget *gui_board_new(void)
{
	GtkWidget *container;

	container = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(container, 300, 300);
	board_widget = _gui_board_table_new();
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(container), board_widget);

	return container;
}

void gui_board_clear(void)
{
	int x, y;

	for(x=0; x<BOARD_XSIZE; x++)
		for(y=0; y<BOARD_YSIZE; y++)
			if(!GTK_IS_BUTTON(pieces[x][y])) {
				gtk_widget_destroy(pieces[x][y]);
				gtk_signal_connect(GTK_OBJECT(pieces[x][y] = _empty_button_new()), "clicked", GTK_SIGNAL_FUNC(_cb_square_clicked), (gpointer)(y * BOARD_XSIZE + x));
				gtk_table_attach_defaults(GTK_TABLE(board_widget), pieces[x][y], x, x+1, y, y+1);
			}
}

void static _board_square_set(Coordinate *coor, GtkWidget *w)
{
	int x = coor->xy[0], y = coor->xy[1];

	gtk_widget_destroy(pieces[x][y]);
	pieces[x][y] = w;
	gtk_widget_show(pieces[x][y]);
	gtk_table_attach_defaults(GTK_TABLE(board_widget), pieces[x][y], x, x+1, y, y+1);
}

void gui_board_square_set_last(Coordinate *coor, int s)
{
	_board_square_set(coor, gtk_label_new(s ? "x":"o"));
}

void gui_board_square_set_normal(Coordinate *coor, int s)
{
	_board_square_set(coor, gtk_label_new(s ? "X":"O"));
}

void gui_board_square_delete(Coordinate *coor)
{
	GtkWidget *w = _empty_button_new();
	int x = coor->xy[0], y = coor->xy[1];

	gtk_signal_connect(GTK_OBJECT(w), "clicked", GTK_SIGNAL_FUNC(_cb_square_clicked), (gpointer)(y * BOARD_XSIZE + x));
	_board_square_set(coor, w);
}
