#ifndef TEXTIO_HH
#define TEXTIO_HH
#include "standard.hh"
#include <ctype.h>
#include "SavantlineType.hh"
#include "SavanttextType.hh"

extern enumInfo SavantsideType_info;
extern rangeInfo SavantwidthType_info;

class VHDLKernelBase;

extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, 
		      const PhysicalType&);  

extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>&, 
		       const PhysicalType&, const Side_t = RIGHT, 
		       const int = 0, TimeUnit_t = NS);

extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, VTime&);

extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>&, const VTime&, 
		       const Side_t = RIGHT, const int = 0, 
		       TimeUnit_t = NS);

extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, EnumerationType&);
extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
		       const EnumerationType& var, const Side_t = RIGHT, 
		       const int field = 0);

extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, 
		      IntegerType&);
extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>&, 
		       const IntegerType&, const Side_t = RIGHT, 
		       const int = 0);

extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>&, 
		       const RealType&, const Side_t = RIGHT, 
		       const int = 0, const int = 0);
extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, 
		       RealType&);

extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, 
		      Savantbit_vectorType&);
extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
		       const Savantbit_vectorType& var, const Side_t = RIGHT, 
		       const int field = 0);

extern int savantread(VHDLKernelBase*, AccessVariable<char*>&, 
		      SavantstringType&);
extern int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
		       const SavantstringType& var, const Side_t = RIGHT, 
		       const int field = 0);

// Modified from here

extern int savantwrite(VHDLKernelBase*, SavantlineType &, 
		       const PhysicalType&, const Side_t = RIGHT, 
		       const int = 0, TimeUnit_t = NS);

extern int savantwrite(VHDLKernelBase *base, SavantlineType &line,
		       const VTime &time, const Side_t side = RIGHT, 
		       const int i = 0, TimeUnit_t t_unit = NS);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line, 
		       const EnumerationType& var, const Side_t = RIGHT, 
		       const int = 0);

extern int savantwrite(VHDLKernelBase*, SavantlineType &, 
		       const EnumerationType&, const Side_t justified, 
		       const IntegerType&);

extern int savantwrite(VHDLKernelBase *base, SavantlineType &line,
		       const IntegerType &var, const Side_t = RIGHT,
		       const int field = 0);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line,
		       const RealType&, const Side_t = RIGHT, 
		       const int = 0);
extern int savantwrite(VHDLKernelBase*, SavantlineType &line,
		       const Savantbit_vectorType&, const Side_t = RIGHT, 
		       const int = 0);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line,
		       const SavantstringType &var, const Side_t = RIGHT,
		       const int field = 0);

extern int savantread(VHDLKernelBase*, SavantlineType&, 
		      PhysicalType&);
extern int savantread(VHDLKernelBase*, SavantlineType&, EnumerationType&);
extern int savantread(VHDLKernelBase*, SavantlineType&,
		      IntegerType&);
extern int savantread(VHDLKernelBase*, SavantlineType&,
		      EnumerationType&);
extern int savantread(VHDLKernelBase*, SavantlineType&,
		      RealType&);
extern int savantread(VHDLKernelBase*, SavantlineType&,
		      Savantbit_vectorType&);
extern int savantread(VHDLKernelBase*, SavantlineType&,
		      SavantstringType&);

// Second set of modifications start here

extern int savantwrite(VHDLKernelBase*, SavantlineType &, 
		       const PhysicalType&, const EnumerationType&,  
		       const IntegerType&, const PhysicalType&);

extern int savantwrite(VHDLKernelBase *base, SavantlineType &line,
		       const VTime &time, const EnumerationType&, 
		       const IntegerType&,
		       TimeUnit_t t_unit = NS);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line, 
		       const EnumerationType& var, const EnumerationType&, 
		       const IntegerType&);

extern int savantwrite(VHDLKernelBase *base, SavantlineType &line,
		       const IntegerType &var, const EnumerationType&,
		       const IntegerType &);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line,
		       const RealType&, const EnumerationType&, 
		       const IntegerType&, const IntegerType&);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line,
		       const Savantbit_vectorType&, const EnumerationType&, 
		       const IntegerType&);

extern int savantwrite(VHDLKernelBase*, SavantlineType &line,
		       const SavantstringType &, const EnumerationType&, 
		       const IntegerType&);

// Some of the methods that are needed after the scalar types were
// folded into the kernel.

int savantread_bit(VHDLKernelBase*, AccessVariable<char*>&, EnumerationType&);
int savantread_character(VHDLKernelBase*, AccessVariable<char*>&, EnumerationType&);

#endif
