#include "SavantstringType.hh"
#include "Vector.hh"
#include "ElementAssociation.hh"
#include "standard.hh"

rangeInfo SavantstringType_rangeInfo[] = {rangeInfo(UniversalInteger((int)1), to, UniversalInteger( (int)2147483647))};

arrayTypeInfo SavantstringType_info(1, SavantstringType_rangeInfo);

SavantstringType::SavantstringType(ObjectBase::ObjectType objType,
				   const TypeInfo&) : ArrayType(objType) {
  if (ArrayType::rangeInfo != NULL) {
    object = new     Vector<EnumerationType> (objType);
    object->setRange(objType, ArrayType::rangeInfo, 1, SavantcharacterType_info);
  }
  else {
    object = NULL;
  }
}

SavantstringType::SavantstringType(ObjectBase::ObjectType objType, 
				   int left, ArrayDirn_t dirn, int right,
				   const TypeInfo&) {
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantcharacterType_info);
}

SavantstringType::SavantstringType(ObjectBase::ObjectType objType, 
				   int left, ArrayDirn_t dirn, int right,
				   char* value, const TypeInfo&) {
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantcharacterType_info);
  this->operator=(value);
}

SavantstringType::SavantstringType(ObjectBase::ObjectType objType, 
				   char* value, const TypeInfo&) {
  ArrayInfo aInfo = ArrayInfo(1, to, strlen(value));
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantcharacterType_info);
  this->operator=(value);
}

SavantstringType::SavantstringType(ObjectBase::ObjectType objType, 
				  int left, ArrayDirn_t dirn, 
				   int right, const SavantstringType& tmp) {
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantcharacterType_info);
  *object = *(tmp.object);
}

SavantstringType::SavantstringType(ObjectBase::ObjectType objType, 
				   const SavantstringType& value) {
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, value.object);
  *object = *(value.object);
}

SavantstringType::SavantstringType(const SavantstringType& value) {
  ObjectBase::ObjectType objType = value.getKind();
  object = new     Vector<EnumerationType> (objType);
  object->setRange(objType, value.object);
  *object = *(value.object);
}

//Constructor for alias initialization
SavantstringType::SavantstringType(bool alias, ObjectBase::ObjectType,
				   int left, ArrayDirn_t dirn, int right,
				   const ArrayType& actual,
				   const ArrayInfo& boundsOfActual): ArrayType(alias) {
  ArrayInfo actualBounds = boundsOfActual;
  
  if(boundsOfActual == nullInfo) {
    actualBounds = actual.object->bounds;
  }
  object = actual.object->getNewArray(ArrayInfo(left, dirn, right), actualBounds);
}

//Constructor for aggregate initialization
SavantstringType::SavantstringType(ObjectBase::ObjectType objType, 
		 int left, ArrayDirn_t dirn, int right,
		 int noofElmntAssns, ...) {
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantcharacterType_info);
    
  va_list ap;
  ElementAssociation* elmtptr;
  ElementAssociation* othersAssociation;
  ElementAssociation** elmtAssocArray;
  char* charptr = NULL;
  int i=0;
  int j=0;

  charptr = new char[object->numElems];
  elmtAssocArray = (ElementAssociation**) new char[noofElmntAssns *
						  sizeof(ElementAssociation*)];
  for (i=0; i < object->numElems; i++) {
    charptr[i] = 'U';
  }

  va_start(ap, noofElmntAssns);
  for(i =0; i < noofElmntAssns; i++) {
    elmtAssocArray[i] = va_arg(ap, ElementAssociation*);
  }
  va_end(ap);
    
  for(i =0; i < noofElmntAssns; i++) {
    elmtptr = elmtAssocArray[i];
    if(elmtptr->choice == Others) {
      othersAssociation = elmtptr;
      break;
    }
    else {
      if(elmtptr->choice.left() == elmtptr->choice.right()) {
	(*this->object)[elmtptr->choice.left()].assignVal(*elmtptr->value);
	charptr[this->object->bounds.storageIndex(elmtptr->choice.left())]
	  = 'I';

      }
      else {
	if(elmtptr->choice.dirn() == to) {
	  for(j=elmtptr->choice.left(); j < elmtptr->choice.right(); j++) {
	    (*this->object)[j].assignVal(*elmtptr->value);
	    charptr[this->object->bounds.storageIndex(j)] = 'I';
	  }
	}
	else {
	  for(j=elmtptr->choice.left(); j > elmtptr->choice.right(); j--) {
	    (*this->object)[j].assignVal(*elmtptr->value);
	    charptr[this->object->bounds.storageIndex(j)] = 'I';
	  }
	}
      }
    }
  }

  for(i=0; i < object->numElems; i++) {
    if(charptr[i] == 'U') {
      this->object->get_element(i) = *othersAssociation->value;
    }
  }

  for(i =0; i < noofElmntAssns; i++) {
    delete  elmtAssocArray[i]->value;
    delete  elmtAssocArray[i];
  }
  if(elmtAssocArray != NULL) {
    delete [] elmtAssocArray;
  }
  delete charptr;
    
}

SavantstringType::~SavantstringType() {}

SavantstringType&
SavantstringType::getSlice(const ArrayInfo& newBounds) {
  return *(SavantstringType *) getNewArray(newBounds, newBounds);
}

VHDLType& 
SavantstringType::operator=(const VHDLType& val) {
  if (object == NULL) {
    object = (VectorBase *) ((SavantstringType &) val).object->clone();
  }
  is_alias = val.is_alias;
  *object = *((const SavantstringType &) val).object;
  return *this;
}

SavantstringType& 
SavantstringType::operator=(const SavantstringType& val) {
  if (object == NULL) {
    object = (VectorBase *) val.object->clone();
  }
  is_alias = val.is_alias;
  *object = *val.object;
  return *this;
}

VHDLType& 
SavantstringType::operator=(const char *str) {
  register int leftlimit = object->bounds.left();
  register int rightlimit =  object->bounds.right();
  register int i = 0;
    
  if(object->bounds.dirn() == to) {
    for(i = leftlimit; i <= rightlimit; i++) {
      ((EnumerationType &)(*object)[i]).object->updateVal(UniversalInteger((int) str[i - leftlimit]));
    }
  } else {
    for(i = leftlimit; i >= rightlimit; i--) {
      ((EnumerationType &)(*object)[i]).object->updateVal(UniversalInteger((int) str[leftlimit - i]));
    }
  }
  return (*this);
}


extern ostream& operator << (ostream& os, const SavantstringType& str) {
  int length = str.object->bounds.length();
  for(register int i = 0; i < length; i++) {
    os << (EnumerationType &) str.object->get_element(i);
  }
  return os;
}

EnumerationType
savantEqual(const SavantstringType &lhs, const SavantstringType &rhs) {

  bool lhs_is_null_range = lhs.object->bounds.is_null_range();
  bool rhs_is_null_range = rhs.object->bounds.is_null_range();

  //Checking for null arrays
  if( lhs_is_null_range && rhs_is_null_range) {
    return SAVANT_BOOLEAN_TRUE;
  }
  else if( lhs_is_null_range || rhs_is_null_range) {
    return SAVANT_BOOLEAN_FALSE;
  }

  int lhs_left      = lhs.object->bounds.left();
  int rhs_left      = rhs.object->bounds.left();
  int lhs_counter   = 0;
  int rhs_counter   = 0;
  int lhs_increment = lhs.object->bounds.dirn();
  int rhs_increment = rhs.object->bounds.dirn();
  
  if (lhs.get_number_of_elements() != rhs.get_number_of_elements()) {
    return SAVANT_BOOLEAN_FALSE;
  }

  for(register int counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    if (SAVANT_BOOLEAN_FALSE == 
	savantEqual((const EnumerationType&) lhs[lhs_counter + lhs_left], 
		    (const EnumerationType&) rhs[rhs_counter + rhs_left]))
      return SAVANT_BOOLEAN_FALSE;
    
    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }

  return SAVANT_BOOLEAN_TRUE;
}

VHDLType&
SavantstringType::operator[](const int i) const {
  return (EnumerationType &) (*object)[i];
}

EnumerationType&
SavantstringType::operator[](const ScalarType& indexSubscript) const {
  UniversalInteger val = (UniversalInteger &) indexSubscript.object->readVal();
  return (EnumerationType&) (*object)[int(val)];
}

EnumerationType
savantNotEqual(const SavantstringType &lhs, const SavantstringType &rhs)
{
  return savantNot(savantEqual(lhs, rhs));
}

EnumerationType
savantLessThan(const SavantstringType &lhs, const SavantstringType &rhs)
{
  bool lhs_is_null_range = lhs.object->bounds.is_null_range();
  bool rhs_is_null_range = rhs.object->bounds.is_null_range();
  
  //Checking for null arrays
  if( lhs_is_null_range && rhs_is_null_range) {
    return SAVANT_BOOLEAN_TRUE;
  }
  else if( lhs_is_null_range || rhs_is_null_range) {
    return SAVANT_BOOLEAN_FALSE;
  }

  int lhs_left      = lhs.object->bounds.left();
  int rhs_left      = rhs.object->bounds.left();
  int lhs_counter   = 0;
  int rhs_counter   = 0;
  int lhs_increment = lhs.object->bounds.dirn();
  int rhs_increment = rhs.object->bounds.dirn();
  
  if (lhs.get_number_of_elements() != rhs.get_number_of_elements()) {
    return SAVANT_BOOLEAN_FALSE;
  }
  
  for(register int counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    if (SAVANT_BOOLEAN_FALSE == savantLessThan((EnumerationType&) lhs[lhs_counter + lhs_left], (EnumerationType&) rhs[rhs_counter + rhs_left]))
      return SAVANT_BOOLEAN_FALSE;
    
    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }

  return SAVANT_BOOLEAN_TRUE;
}

EnumerationType
savantLessThanOrEqual(const SavantstringType &lhs, const SavantstringType &rhs) {
  return savantOr(savantLessThan(lhs, rhs), savantEqual(lhs, rhs));
}

EnumerationType
savantGreaterThan(const SavantstringType &lhs, const SavantstringType &rhs)
{
  return savantNot(savantLessThanOrEqual(lhs, rhs));
}

EnumerationType
savantGreaterThanOrEqual(const SavantstringType &lhs, const SavantstringType &rhs)
{
  return savantNot(savantLessThan(lhs, rhs));
}

const ScalarType
SavantstringType::LEFT_O(const IntegerType& n) const{
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = (*this).object->bounds.left();
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const ScalarType
SavantstringType::RIGHT_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = (*this).object->bounds.right();
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const ScalarType
SavantstringType::HIGH_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = ((*this).object->bounds.dirn() == to ? (*this).object->bounds.right() : (*this).object->bounds.left());
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const ScalarType
SavantstringType::LOW_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = ((*this).object->bounds.dirn() == to ? (*this).object->bounds.left() : (*this).object->bounds.right());
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const IntegerType
SavantstringType::LENGTH_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = (*this).object->bounds.length();
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const EnumerationType
SavantstringType::ASCENDING_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  switch(val) {
  case 1:
    if((*this).object->bounds.dirn() == to) {
      return SAVANT_BOOLEAN_TRUE;
    } else {
      return SAVANT_BOOLEAN_FALSE;
    }
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

SavantstringType
conCatenate(const VHDLType& lhs, const VHDLType& rhs) {
  char* lhs_ptr = lhs.getString();
  char* rhs_ptr = rhs.getString();
  char* buffer = new char[strlen(lhs_ptr) + strlen(rhs_ptr)];
  strcpy(buffer, lhs_ptr);
  strcat(buffer, rhs_ptr);
  static SavantstringType* retval = NULL;
  //This has been allocated previously
  //I can delete it now
  if(retval != NULL) {
    delete retval;
  }
  retval = new SavantstringType(ObjectBase::VARIABLE, buffer);
  retval->object->bounds = ArrayInfo(lhs.left(), lhs.dirn(), 
				     lhs.left() + strlen(buffer) - 1);

  delete []lhs_ptr;
  delete []rhs_ptr;
  delete []buffer;
  return *retval;
}

SavantstringType
savantConcatenate(const SavantstringType& lhs, const SavantstringType& rhs) {
  return conCatenate(lhs, rhs);
}

SavantstringType
savantConcatenate(const EnumerationType& lhs, const SavantstringType& rhs) {
  return conCatenate(lhs, rhs);
}

SavantstringType
savantConcatenate(const SavantstringType& lhs, const EnumerationType& rhs) {
  return conCatenate(lhs, rhs);
}

SavantstringType
savantConcatenate(const EnumerationType& lhs, const EnumerationType& rhs, SavantstringType*) {
  return conCatenate(lhs, rhs);
}
