#include "SourceTypeConvert.hh"
#include "TypeConvert.hh"

SourceTypeConvert::SourceTypeConvert() {
  data = NULL;
  conversionNode = NULL;
}

SourceTypeConvert::~SourceTypeConvert() {
  conversionNode = NULL;
}

// When a resolve is called on this node. We in turn call a resolve on the
// TypeConvert node which does the TypeConversion. TypeConvert does the type
// conversion and puts the resultant value in the driver pointer to by data.
// Once the typeconversion is over, the data contains the typeconverted value.
VHDLType *
SourceTypeConvert::resolve(VHDLKernelBase* processPtr, SigType) {
  conversionNode->resolve(processPtr);
  if ( data->getParentCompositeType() != NULL ){
    return data->getParentCompositeType();
  } else {
    return data;
  }
}

void
SourceTypeConvert::setData(VHDLType *inData){
  data = inData;
}

void
SourceTypeConvert::setTypeConvert(TypeConvert *nodePtr){
  conversionNode = nodePtr;
}

