#ifndef SCALARTYPE_HH
#define SCALARTYPE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#ifndef ASSERT
#ifdef DEVELOPER_ASSERTIONS
#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <assert.h>
#define ASSERT( x ) assert( x )
#else
#define ASSERT( x )
#endif
#endif

#include "ObjectBase.hh"
#include "VHDLType.hh"
#include "TypeInfo.hh"

class VectorBase;
enum ArrayDirn_t;
class VHDLKernelBase;

class ScalarType : public VHDLType {
public:
  ScalarType() : VHDLType() {}
  ScalarType(ObjectBase::ObjectType, bool alias = false);
  ScalarType(const ScalarType&);

  virtual ~ScalarType();

  bool is_scalar_type() const { return true; }

  void setRange(ObjectBase::ObjectType, ArrayInfo*, int = 1, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  void setRange(ObjectBase::ObjectType, VectorBase*);

  virtual void print(ostream& os) const;

  //Remember to delete the return char* in the place where it is used.
  virtual char* getString() const;

  // This method just returns 1.  It is required in concatenation
  // operator, while concatenating a scalar type and a scalar type to get
  // an array type.
  int left() const;
  ArrayDirn_t dirn() const;
  int right() const;
  void increment();
  void decrement();

  VHDLType& operator =(const VHDLType& val);
  virtual ScalarType& operator =(const ScalarType& val);
  VHDLType& assignVal(const VHDLType& val);

  bool operator==(const VHDLType&) const;

  virtual ObjectBase* getObject() const;
  virtual const VHDLData& getVHDLData() const;
  virtual void setVHDLData(const VHDLData&);
  virtual ObjectBase::ObjectType getKind() const;

  virtual VHDLType* clone() const;

  int savantwrite(AccessVariable <char*>&  line) const;
  int savantwrite(SavantlineType& line) const;
  int savantread(AccessVariable <char*>& line);
  int savantread(SavantlineType& line);

  //The TYPE's resolve is called only for composite resolved signals
  //This resolve goes down to first sub-element of the VHDLType and
  //calls the sub-elements resolve, but which actually does the resolution
  //for the whole composite type
  virtual VHDLType* resolve(VHDLKernelBase*);
  virtual void updateEffVal(const VHDLType*);
  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);

  virtual void setParentCompositeType(VHDLType*);
  virtual void setCompositeResolvedSignal(bool);
  void setElaborationInfo(const VHDLType&);
  void setNumAttributes(int noAttribs);
  void setAttrib(AttribType, VHDLType&);
  void initializeImplicitSignal(AttribType);

  virtual const VHDLData& leftValue();
  virtual bool _is_signal() const { return object->_is_signal(); }

  virtual bool overflow() const;
  virtual SignalBase* locateSig(int);
  virtual SignalBase* findSigInBlock(int,int);
  void setBusKind();
//Pointer to the type of the object
  ObjectBase* object;

  virtual int get_number_of_elements() const { return 1; }
  virtual void dump_connectivity_info(ofstream&);
};

extern ScalarType savantPlus(const ScalarType &, const ScalarType &);
extern ScalarType savantMinus(const ScalarType &, const ScalarType &);
extern ScalarType savantPow(const ScalarType &, const ScalarType &);

extern UniversalInteger getIndex(const char* ptr, char** imageMap, int);

extern EnumerationType savantEqual(const ScalarType&, const ScalarType&);
extern EnumerationType savantNotEqual(const ScalarType&, const ScalarType&);
extern EnumerationType savantLessThan(const ScalarType&, const ScalarType&);
extern EnumerationType savantLessThanOrEqual(const ScalarType&, 
					       const ScalarType&);
extern EnumerationType savantGreaterThan(const ScalarType&,
					   const ScalarType&);
extern EnumerationType savantGreaterThanOrEqual(const ScalarType&, 
						  const ScalarType&);
#endif

