#include "ScalarType.hh"
#include "Types.hh"
#include "AccessVariable.hh"
#include "SavantlineType.hh"
#include "ArrayInfo.hh"
#include "SignalBase.hh"
#include "STDTypes.hh"
#include "SignalBase.hh"

ScalarType::ScalarType(ObjectBase::ObjectType, bool alias) : VHDLType(alias) { 
    object = NULL;
}

ScalarType::ScalarType(const ScalarType& s) {
  object = s.object->clone();	// Returns an identical object.
  is_alias = s.is_alias;
}

ScalarType::~ScalarType() {
  if(is_alias == false && object != NULL) {
    delete object;
    object = NULL;
  }
}

void
ScalarType::setRange(ObjectBase::ObjectType, ArrayInfo*, int, const TypeInfo&) {
  cerr << "This should NEVER be called" << endl;
  abort();
}

char*
ScalarType::getString() const {
  char* ptr = new char[2];
  ptr[0] = (char) ((UniversalInteger &)object->readVal()).val;
  ptr[1] = '\0';
  return ptr;
}

int 
ScalarType::left() const {
  return 1;
}

ArrayDirn_t
ScalarType::dirn() const {
  return to;
}

int 
ScalarType::right() const {
  return 1;
}

void
ScalarType::increment() {
  ((UniversalInteger &) getVHDLData()).increment();
}

bool
ScalarType::overflow() const
{
  return ((UniversalInteger &) getVHDLData()).overflow();
}

void
ScalarType::decrement() {
  ((UniversalInteger &) getVHDLData()).decrement();
}

void
ScalarType::setRange(ObjectBase::ObjectType, VectorBase*) {
  cerr << "This should NEVER be called" << endl;
  abort();
}

void 
ScalarType::print(ostream& os) const {
  object->print(os);
}

VHDLType& 
ScalarType::operator =(const VHDLType& val) {
  object->operator=(*val.getObject());
  //I have commented this out because the destinations alias should
  //remain the same and not be copied from the source 
  //is_alias = val.is_alias;
  if (&getTypeInfo() != &TypeInfo::NULL_TYPE_INFO)  {
    this->getTypeInfo().operator=(val.getTypeInfo());
  }
  return (*this);
}

bool 
ScalarType::operator==(const VHDLType& val) const {
  ASSERT(val.is_scalar_type() == true);
  return INT_TO_BOOL(!(object->readVal() != ((ScalarType&)val).getVHDLData()));
}

VHDLType& 
ScalarType::assignVal(const VHDLType& val) {
  if(val.is_alias == true) {
    if ( object != NULL ){
      delete object;
    }
    object = val.getObject();
    is_alias = true;
  } else {
    *this = val;
  }
  return (*this);
}

ScalarType& 
ScalarType::operator =(const ScalarType& val) {
  object->operator=(*val.getObject());
  return (*this);
}

ObjectBase* 
ScalarType::getObject() const {
  return object;
}

ObjectBase::ObjectType
ScalarType::getKind() const {
  return object->getKind();
}

const VHDLData& 
ScalarType::getVHDLData() const {
  ASSERT(object != NULL);
  return object->readVal();
}

void
ScalarType::setVHDLData(const VHDLData& val) {
  ASSERT(object != NULL);
  object->updateVal(val);
}

VHDLType*
ScalarType::clone() const {
  VHDLType *retval = new ScalarType(*this);
  return retval;
}

void
ScalarType::setResolutionFunctionId(int resolutionFnId) {
  ASSERT(this->getKind() == ObjectBase::SIGNAL_NETINFO);
  this->getObject()->setResolutionFunctionId(resolutionFnId);
}

void
ScalarType::setTypeConversionFunctionId(int typeConversionFnId) {
  ASSERT(this->getKind() == ObjectBase::SIGNAL_NETINFO);
  this->getObject()->setTypeConversionFunctionId(typeConversionFnId);
}

void
ScalarType::setElaborationInfo(const VHDLType &obj_info) {
  ASSERT(_is_signal() == true);
  object->setElaborationInfo(*(((ScalarType&)obj_info).object));
}

void
ScalarType::setNumAttributes(int noAttribs) {
  ASSERT(_is_signal() == true);
  object->setNumAttributes(noAttribs);
}

void
ScalarType::setAttrib(AttribType typ, VHDLType& attr) {
  ASSERT(_is_signal() == true);
  object->setAttrib(typ, attr);
}

void
ScalarType::updateEffVal(const VHDLType* newEffVal) {
  ASSERT(this->getKind() == ObjectBase::SIGNAL);
  ASSERT(newEffVal->is_scalar_type() == true);
  this->getObject()->updateVal(((ScalarType*)newEffVal)->getVHDLData());
}

void
ScalarType::setParentCompositeType(VHDLType* ptr) {
  this->getObject()->setParentCompositeType(ptr);
}

void
ScalarType::setCompositeResolvedSignal(bool val) {
  this->getObject()->setCompositeResolvedSignal(val);
}

void
ScalarType::dump_connectivity_info(ofstream& fileStream) {
  switch(get_kind()) {
  case INTEGER_TYPE:
  case ENUMERATION_TYPE:
  case REAL_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    ((SignalNetinfo*)getObject())->dump_connectivity_info(fileStream);
    ((SignalNetinfo*)getObject())->dump_driver_data(fileStream);
    break;
  }
}

VHDLType*
ScalarType::resolve(VHDLKernelBase* processPtr) {
  VHDLType *retval = this->getObject()->resolve(processPtr);
  // we check whether this scalar type is part of a composite resolved
  // type. If it is so, then we don't care. Otherwise, we need to update
  // the value of this scalar type with the value what we get from the
  // resolve

  // checking whether this scalar type is part of a composite resolved
  // type is done using the VHDLType *parentCompositeType value. If it
  // is not NULL, then this scalar type is part of a composite resolved
  // type.

  if ( this->getObject()->getParentCompositeType() == NULL){
    assignVariable(*this, *retval, nullInfo, nullInfo);
  }

  return retval;
}

int
ScalarType::savantwrite(AccessVariable <char*> &line) const
{
  ostrstream tempStr;
  char *temp_char_str;

  if (line.val != NULL) {
    tempStr << line.val;
  }
 
  this->getVHDLData().savantwrite(tempStr);
  tempStr << '\0' << ends;
  
  if (line.val != NULL) {
    delete line.val;
  }
  
  temp_char_str = tempStr.str();
  line.val = new char[strlen(temp_char_str)];
  memcpy(line.val, tempStr.str(), strlen(temp_char_str));
  line.dataLength = strlen(temp_char_str);
  
  delete [] temp_char_str;
  return NORMAL_RETURN;
}

int
ScalarType::savantwrite(SavantlineType &line) const
{
  this->getVHDLData().savantwrite(line);

  return NORMAL_RETURN;
}

int
ScalarType::savantread(AccessVariable <char*>& line)
{
  char     *tempStr = new char[line.dataLength + 1];
  VHDLData *tempData;
  
  if (line.val != NULL) {
    memcpy(tempStr, line.val, line.dataLength);
  }
  
  tempStr[line.dataLength] = '\0';
  
  tempData = this->getVHDLData().clone();
  tempData->savantread(tempStr);
  this->getObject()->updateVal(*tempData);

  delete tempData;

  if (line.val != NULL) {
    delete line.val;
  }

  int length      = strlen(tempStr);
  line.val        = new char[length];
  line.dataLength = length;
  memcpy(line.val, tempStr, length);
  
  return NORMAL_RETURN;
}

int
ScalarType::savantread(SavantlineType &line)
{
  VHDLData   *tempData;
  
  tempData = this->getVHDLData().clone();
  tempData->savantread(line);
  this->getObject()->updateVal(*tempData);

  delete tempData;

  return NORMAL_RETURN;
}

const VHDLData&
ScalarType::leftValue() {
  cerr << "ERROR!!! ScalarType::leftValue() called " << endl;
  abort();
  return *(new UniversalInteger(-1));
}

void
ScalarType::initializeImplicitSignal(AttribType attribType) {
  ObjectBase* object = this->getObject();
  SignalBase* signal = NULL;
  UniversalInteger tmp_integer(0);
  switch(attribType) {
  case LAST_EVENT:
  case LAST_ACTIVE:
    object->updateVal(UniversalLongLongInteger(-1));
    break;
  case EVENT:
  case ACTIVE:
    object->updateVal(UNIVERSAL_FALSE);
    break;
  case QUIET:
  case STABLE:
    signal = (SignalBase*)object;
    signal->updateDrvVal(&UNIVERSAL_TRUE, NULL, NULL);
    signal->updateEffVal(&UNIVERSAL_TRUE, NULL, NULL);
    break;
  case TRANSACTION:
    signal = (SignalBase*)object;
    signal->updateDrvVal(&tmp_integer, NULL, NULL);
    signal->updateEffVal(&tmp_integer, NULL, NULL);
    break;
  case LAST_VALUE:
    object->updateVal(leftValue());
    break;
  default:
    cerr << "Yet to take care of initializing Implicit attribute: " << attribType << endl;
    break;
  };
}

EnumerationType 
savantEqual(const ScalarType& lhs, const ScalarType& rhs) {
  if(((VHDLData &) lhs.getObject()->readVal()) != ((VHDLData &) rhs.getObject()->readVal())) {
    return SAVANT_BOOLEAN_FALSE;
  } else {
    return SAVANT_BOOLEAN_TRUE;
  }
}

EnumerationType 
savantNotEqual(const ScalarType& lhs, const ScalarType& rhs) {
  if(lhs.getObject()->readVal() != rhs.getObject()->readVal()) {
    return SAVANT_BOOLEAN_TRUE;
  } else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

EnumerationType 
savantLessThanOrEqual(const ScalarType& lhs, const ScalarType& rhs) {
  if(lhs.getObject()->readVal() <= rhs.getObject()->readVal()) {
    return SAVANT_BOOLEAN_TRUE;
  } else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

EnumerationType 
savantLessThan(const ScalarType& lhs, const ScalarType& rhs) {
  if(lhs.getObject()->readVal() < rhs.getObject()->readVal()) {
    return SAVANT_BOOLEAN_TRUE;
  } else {
    return SAVANT_BOOLEAN_FALSE;
  }
}


EnumerationType 
savantGreaterThanOrEqual(const ScalarType& lhs, const ScalarType& rhs) {
  if(lhs.getObject()->readVal() >= rhs.getObject()->readVal()) {
    return SAVANT_BOOLEAN_TRUE;
  } else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

EnumerationType 
savantGreaterThan(const ScalarType& lhs, const ScalarType& rhs) {
  if(lhs.getObject()->readVal() > rhs.getObject()->readVal()) {
    return SAVANT_BOOLEAN_TRUE;
  } else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

ScalarType
savantPlus(const ScalarType &lhs, const ScalarType &rhs)
{
  ScalarType tempScalar(ObjectBase::VARIABLE);
  VHDLData* tempData;

  switch (lhs.get_kind()) {
  case INTEGER_TYPE:
    tempScalar.object = lhs.object->clone();
    tempScalar = savantPlus((IntegerType &) lhs, (IntegerType &) rhs);
    break;

  case REAL_TYPE:
    tempScalar.object = lhs.object->clone();
    tempScalar = savantPlus((RealType &) lhs, (RealType &) rhs);
    break;

  case PHYSICAL_TYPE:
    tempScalar.object = lhs.object->clone();
    tempScalar = savantPlus((PhysicalType &) lhs, (PhysicalType &) rhs);
    break;

  case NO_TYPE:
    tempScalar.object  = lhs.object->clone();
    tempData = savantPlus((VHDLData &) lhs.getVHDLData(), (VHDLData &) rhs.getVHDLData());
    tempScalar.setVHDLData(*tempData);
    delete tempData;
    break;
    
  default:
    cerr << "Error : Illegal call to savantPlus(ScalarType &, ScalarType &)\n";
  }

  return tempScalar;
}

ScalarType
savantMinus(const ScalarType &lhs, const ScalarType &rhs)
{
  ScalarType tempScalar(ObjectBase::VARIABLE);
  VHDLData* tempData;

  switch (lhs.get_kind()) {
  case INTEGER_TYPE:
    tempScalar.object = lhs.object->clone();
    tempScalar = savantMinus((IntegerType &) lhs, (IntegerType &) rhs);
    break;

  case REAL_TYPE:
    tempScalar.object = lhs.object->clone();
    tempScalar = savantMinus((RealType &) lhs, (RealType &) rhs);
    break;

  case PHYSICAL_TYPE:
    tempScalar.object = lhs.object->clone();
    tempScalar = savantMinus((PhysicalType &) lhs, (PhysicalType &) rhs);
    break;

  case NO_TYPE:
  case ENUMERATION_TYPE:
    tempScalar.object = lhs.object->clone();
    tempData = savantMinus((VHDLData &) lhs.getVHDLData(), (VHDLData &) rhs.getVHDLData());
    tempScalar.setVHDLData(*tempData);
    delete tempData;
    break;

  default:
    cerr << "Error : Illegal call to savantMinus(ScalarType &, ScalarType &)\n";
  }

  return tempScalar;
}

ScalarType
savantPow(const ScalarType &lhs, const ScalarType &rhs)
{
  ScalarType tempScalar(ObjectBase::VARIABLE);
  tempScalar.object = lhs.object->clone();

  switch (lhs.get_kind()) {
  case INTEGER_TYPE:
    tempScalar = savantPow((IntegerType &) lhs, (IntegerType &) rhs);
    break;

  case REAL_TYPE:
    tempScalar = savantPow((RealType &) lhs, (RealType &) rhs);
    break;

  default:
    cerr << "Error : Illegal call to savantPow(ScalarType &, ScalarType &)\n";
  }

  return tempScalar;
}

UniversalInteger
getIndex(const char* ptr, char** imageMap, int number_of_elements) {
  for(int i=0; i< number_of_elements; i++) {
    if ((strlen(imageMap[i]) == 3) && 
	(imageMap[i][0] == '\'') && (imageMap[i][2] == '\'')) {
      if(*ptr == imageMap[i][1]) {
	return UniversalInteger(i+1);
      }
    }
    else {
      if(strcmp(ptr, imageMap[i]) == 0) {
	return UniversalInteger(i+1);
      }
    }
  }
  
  return UniversalInteger(-1);
}
  
SignalBase*
ScalarType::locateSig(int sigId) {
  ASSERT(_is_signal() == true);
  SignalBase* ptr = (SignalBase*)getObject();
  ASSERT ( ptr != NULL );
  if(ptr->id == sigId) {
    return ptr;
  }
  return NULL;
}

void
ScalarType::setBusKind() {
  object->setBusKind();
}

SignalBase*
ScalarType::findSigInBlock(int sigId, int srcId){
  SignalBase *driver_ptr = NULL;
  Block *driverList = NULL;
  int index;

  
  ASSERT(_is_signal() == true);
  ASSERT(getObject() != NULL);
  driverList = ((SignalBase *)getObject())->additionalDriverList;


  driver_ptr =  ((SignalBase *)getObject())->findSigInBlock(sigId, srcId);
  if ( driver_ptr != NULL ){
    return driver_ptr;
  }
  
  if ( driverList != NULL ){
    for ( index = 0 ; index < driverList->getNumberOfElements() ; index++){
      driver_ptr = ((VHDLType *)driverList->getElement(index))->findSigInBlock(sigId, srcId);
      if ( driver_ptr != NULL ){
	return driver_ptr;
      }
    }
  }
  
  return (SignalBase *)NULL;
}
