#ifndef RECORDTYPE_CC
#define RECORDTYPE_CC

//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------
#include "Types.hh"
#include "RecordType.hh"
#include "EnumerationType.hh"

void assignVariable(RecordType& dest, const RecordType& src, 
		    const ArrayInfo&, const ArrayInfo&) {
  register int field_counter;
  
  for(field_counter = 1; (field_counter <= dest.get_number_of_elements());
      field_counter++) {
    dest.get_field(field_counter) = src.get_field(field_counter);
  }
}

VHDLType*
RecordType::clone() const {
  cerr << "RecordType::clone() Can not do this." << endl;
  abort();
  return NULL;
}

ObjectBase::ObjectType
RecordType::getKind() const {
  if(numberOfFields > 0) {
    return get_field(1).getKind();
  }
  else {
    cerr << "Warning Don't know the Object Type" << endl;
    cerr << "I am assuming VARIABLE" << endl;
    return ObjectBase::VARIABLE;
  }
}

bool
RecordType::operator==(const VHDLType &val) const{
  int field;
  ASSERT(val.get_kind() == RECORD_TYPE);
  for(field = 1; field <= numberOfFields; field++) {
    if((get_field(field) == ((RecordType &)val).get_field(field)) == false) {
      return false;
    }
  }
  return true;
}  

VHDLType&
RecordType::assignVal(const VHDLType& val) {
  int field_number;
  ASSERT(val.get_kind() == RECORD_TYPE);
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    get_field(field_number).assignVal( ((RecordType &)val).get_field(field_number));
  }
  return *this;
}

void
RecordType::setResolutionFunctionId(int resolutionFnId) {
  int field_number;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).setResolutionFunctionId(resolutionFnId);
  }
}

void
RecordType::setTypeConversionFunctionId(int typeConversionFnId) {
  int field_number;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).setTypeConversionFunctionId(typeConversionFnId);
  }
}

void
RecordType::setCompositeResolvedSignal(bool val) {
  int field_number;
  
  isCompositeResolvedType = val;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).setCompositeResolvedSignal(val);
  }
}

void
RecordType::setParentCompositeType(VHDLType* ptr) {
  int field_number;
  isCompositeResolvedType = true;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).setParentCompositeType(ptr);
  }
}

void
RecordType::setElaborationInfo(const VHDLType &obj_info) {
  int field_no;
  ASSERT (obj_info.get_kind() == RECORD_TYPE);
  for(field_no = 1; (field_no <= numberOfFields); field_no++) {
    this->get_field(field_no).setElaborationInfo(((RecordType&)obj_info).get_field(field_no));
  }  
}

void
RecordType::setNumAttributes(int noAttribs) {
  int field_no;
  for(field_no = 1; (field_no <= numberOfFields); field_no++) {
    this->get_field(field_no).setNumAttributes(noAttribs);
  }  
}

void
RecordType::setAttrib(AttribType typ, VHDLType& attr) {
  int field_no;
  ASSERT (attr.get_kind() == RECORD_TYPE);
  for(field_no = 1; (field_no <= numberOfFields); field_no++) {
    this->get_field(field_no).setAttrib(typ, ((RecordType&)attr).get_field(field_no));
  }  
}

void
RecordType::updateEffVal(const VHDLType* ptr) {
  int field_number;
  ASSERT(ptr->get_kind() == RECORD_TYPE);
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).updateEffVal(&((RecordType*)ptr)->get_field(field_number));
  }
}

//The TYPE's resolve is called only for composite resolved signals
//This resolve goes down to first sub-element of the VHDLType and
//calls the sub-elements resolve, but which actually does the resolution
//for the whole composite type
// The above given reason was the original reason for writing resolve
// in the RecordTypes. But when TypeConversion came into picture, we needed
// resolve to be written for RecordTypes  even if the RecordType was not a
// composite resolved signal. In case of not a composite resolved type,
// resolve method just goes down to the sub fields  and resolves the
// individual fields and then updates itself once the resolved value is
// obtained.

VHDLType*
RecordType::resolve(VHDLKernelBase* processPtr) {
  int index;
  VHDLType *retval = NULL, *field = NULL;
  
  if( _is_composite_resolved_type() ){
    if ( numberOfFields > 0) {
      retval = this->get_field(1).resolve(processPtr);
      return retval;
    }
    else {
      return NULL;
    }
  } else {
    for ( index = 1 ; index <= numberOfFields; index++){
      field = &(this->get_field(index));
      retval = field->resolve(processPtr);

      if ( field->_is_composite_resolved_type() ){
        *field = *retval;
      }
    }
    return NULL;
  }
}

int
RecordType::savantwrite(AccessVariable <char*>& line) const
{
  int field_number;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).savantwrite(line);
  }

  return NORMAL_RETURN;
}

int
RecordType::savantwrite(SavantlineType &line) const
{
  int field_number;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).savantwrite(line);
  }

  return NORMAL_RETURN;
}

int
RecordType::savantread(AccessVariable <char*>& line)
{
  int field_number;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).savantread(line);
  }

  return NORMAL_RETURN;
}


int
RecordType::savantread(SavantlineType &line)
{
  int field_number;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    this->get_field(field_number).savantread(line);
  }

  return NORMAL_RETURN;
}
    
EnumerationType
savantEqual(const RecordType& lhs, const RecordType& rhs) {
  int field;
  for(field = 1; field <= lhs.numberOfFields; field++) {
    if(savantEqual(lhs.get_field(field), rhs.get_field(field)) == ENUMERATION_FALSE) {
      return ENUMERATION_FALSE;
    }
  }

  return ENUMERATION_TRUE;
}  

EnumerationType
savantNotEqual(const RecordType& lhs, const RecordType& rhs) {
  return savantNot(savantEqual(lhs, rhs));
}

SignalBase*
RecordType::locateSig(int sigId) {
  register int field_number = 1;
  SignalBase* ptr = NULL;
  for(field_number = 1; (field_number <= numberOfFields); field_number++) {
    ptr = this->get_field(field_number).locateSig(sigId);
    if(ptr != NULL) {
      return ptr;
    }
  }
  return NULL;
}

SignalBase*
RecordType::findSigInBlock(int sigId, int srcId){
  int field_index ;
  SignalBase *driver_ptr = NULL;

  for(field_index = 1 ; field_index <= numberOfFields; field_index++){
    driver_ptr = this->get_field(field_index).findSigInBlock(sigId, srcId);
    if ( driver_ptr != NULL ){
      return driver_ptr;
    }
  }
  return (SignalBase *)NULL;
}

bool
RecordType::_is_composite_resolved_type() const {
  return isCompositeResolvedType;
}
#endif
