#ifndef Bit_CC
#define Bit_CC
//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Bit.cc,v 1.6 1999/03/09 22:52:00 dmartin Exp $
//---------------------------------------------------------------------------

#include "Bit.hh"

bool savantEqual(VectorBase& lhs,VectorBase& rhs) {
  if (lhs.bounds.length() != rhs.bounds.length()) {
    return false;
  }
  int lhsidx = lhs.bounds.left();
  int rhsidx = rhs.bounds.left();
  if (lhs[lhsidx] != rhs[rhsidx]) {
    return false;
  }
  while (lhsidx != lhs.bounds.right()) {
    lhsidx = lhs.bounds.rightof(lhsidx);
    rhsidx = rhs.bounds.rightof(rhsidx);
    if (lhs[lhsidx] != rhs[rhsidx]) {
      return false;
    }
  }
  return true;
}


bool savantNotEqual(VectorBase& lhs,  VectorBase& rhs) {
  return !(savantEqual(lhs, rhs));
}


bool savantLessThan( VectorBase& lhs,  VectorBase& rhs) {
 
  int lhsidx = lhs.bounds.left();
  int rhsidx = rhs.bounds.left();
  int lhsLength = lhs.bounds.length();
  int rhsLength = rhs.bounds.length();

  while (lhsidx != lhsLength && rhsidx != rhsLength) {
    if (lhs[lhsidx] > rhs[rhsidx]) {
      return false;
    }
    lhsidx = lhs.bounds.rightof(lhsidx);
    rhsidx = rhs.bounds.rightof(rhsidx);
  }
  if (rhsidx == lhsLength) {
  return false;
  }
  else {
    return true;
  }  
} 

  
bool savantLessThanOrEqual( VectorBase& lhs,  VectorBase& rhs) {
 
  int lhsidx = lhs.bounds.left();
  int rhsidx = rhs.bounds.left();
  int lhsLength = lhs.bounds.length();
  int rhsLength = rhs.bounds.length();

  while (lhsidx != lhsLength && rhsidx != rhsLength) {
    if (lhs[lhsidx] > rhs[rhsidx]) {
      return false;
    }
    lhsidx = lhs.bounds.rightof(lhsidx);
    rhsidx = rhs.bounds.rightof(rhsidx);
  }
  if (lhsidx == lhsLength && rhsidx == rhsLength) {
  return true;
  }
  else {
    if (lhsidx == lhsLength)  return true;
    else   return false;
  }
}


bool savantGreaterThan( VectorBase& lhs,  VectorBase& rhs) {
  return (! savantLessThanOrEqual(lhs, rhs));
}


bool savantGreaterThanOrEqual( VectorBase& lhs,  VectorBase& rhs) {  
  return (! savantLessThan(lhs,rhs));
}


VectorBase& _savant_sll( VectorBase& lhs, int rhs) {
  //since T'left is always 0, we use value 0 instead of right argument here
 int index;
  if ( rhs == 0 || lhs.numbits == 0) {
    return lhs;
  }
  
  for ( register int i = 0; i< rhs; i++) {
    for( index = lhs.numbits -1; index > 0; index -- ) {
      lhs[index] = lhs[index - 1 ];
    }
    lhs[index] = '0';
  }
  return lhs;
}


VectorBase& _savant_srl( VectorBase& lhs, int rhs) {
  //since T'left is always 0, we use value 0 instead of left argument here
  int index;
   if ( rhs == 0 || lhs.numbits == 0) {
    return lhs;
  }

  for ( register int i = 0; i< rhs; i++) {
    for( index = 0; index < lhs.numbits; index++ ) {
      lhs[index] = lhs[index + 1 ];
    }
    lhs[index] = '0';
  }
  return lhs;
}


VectorBase& _savant_sla( VectorBase& lhs, int rhs) {
  //since T'left is always 0, we use value 0 instead of right argument here
  char temp = lhs[0];
  int index;
  if ( rhs == 0 || lhs.numbits == 0) {
    return lhs;
  }
  
  for ( register int i = 0; i< rhs; i++) {
    for( index = lhs.numbits-1; index > 0; index -- ) {
      lhs[index] = lhs[index - 1 ];
    }
    lhs[index] = temp;
  }
  return lhs;
}


VectorBase& _savant_sra( VectorBase& lhs, int rhs) {
  //since T'left is always 0, we use value 0 instead of left argument here
  char temp = lhs[0];
  int index;
   if ( rhs == 0 || lhs.numbits == 0) {
    return lhs;
  }

  for ( register int i = 0; i< rhs; i++) {
    for( index = 0; index < lhs.numbits; index++ ) {
      lhs[index] = lhs[index + 1 ];
    }
    lhs[index] = temp;
  }
  return lhs;
}


VectorBase& _savant_ror( VectorBase& lhs, int rhs) {
  char temp;
  int index;

  if ( rhs == 0 || lhs.numbits == 0) {
    return lhs;
  }
  if ( rhs < 0 ) {
    return _savant_srl( lhs, -rhs);
  }
  else {
    for ( register int i = 0; i< rhs; i++) {
      temp = lhs[0];
      for( index = 0; index < lhs.numbits; index++ ) {
	lhs[index] = lhs[index + 1 ];
      }
    lhs[index] = temp;
    }
    return lhs;
  } // end of else
}


VectorBase& _savant_rol( VectorBase& lhs, int rhs) {
  char temp;
  int index;
  if ( rhs == 0 || lhs.numbits == 0) {
    return lhs;
  }
  
  if ( rhs < 0) {
    return _savant_sll( lhs, -rhs);
  }
  else {
    for ( register int i = 0; i< rhs; i++) {
      temp = lhs[lhs.numbits - 1];
      for( index = lhs.numbits -1; index > 0; index -- ) {
	lhs[index] = lhs[index - 1 ];
      }
      lhs[index] = temp;
    }
    return lhs;
  } //end of else
}


VectorBase& savantConcatenation( VectorBase& lhs,  savantBit& rhs) {
    int length = lhs.length();
    VectorBase  *tempStr = new VectorBase(0, lhs.bounds.dirn(), length);
    int i;
  
    int lhsLeft = lhs.bounds.left();
    if (lhs.bounds.dirn() >  0) {
      for (  i = 0; i < length-1; i++) {
	tempStr->ch[i] = lhs[lhsLeft++];
      }
      tempStr->ch[i] = rhs[0];
    }
    else {
      for (  i = length; i > 0; i --) {
     tempStr->ch[i] = lhs[lhsLeft--];
      }
      tempStr->ch[i] = rhs[0];
  }
    return *tempStr;
}


VectorBase& savantConcatenation(savantBit& lhs,  VectorBase& rhs) {
  int length = rhs.length();
  VectorBase  *tempStr = new VectorBase(0, rhs.bounds.dirn(), length);

int rhsLeft = rhs.bounds.left();
if (rhs.bounds.dirn() >  0) {
  tempStr->ch[0] = lhs[0];
  for ( register int i = 1; i < length; i++) {
    tempStr->ch[i] = rhs[rhsLeft++];
  }
}

else {
  tempStr->ch[length] = lhs[0];
  for ( register int i = length-1; i >=0; i --) {
      tempStr->ch[i] = rhs[rhsLeft--];
    }
}

return *tempStr;
}


VectorBase& savantConcatenation( savantBit& lhs,  savantBit& rhs) {
VectorBase *tempStr = new VectorBase(0, to, 1);
tempStr->ch[0] = lhs[0];
tempStr->ch[1] = rhs[0];
return *tempStr;
}

 VectorBase& savantConcatenation( VectorBase& lhs,  VectorBase& rhs) {
  int lhsLeft = lhs.bounds.left();
  int rhsLeft = rhs.bounds.left();
  int lhsRight = lhs.bounds.right();
  //  int rhsRight = rhs.bounds.right();
  int lhsLength = lhs.bounds.length();
  int rhsLength = rhs.bounds.length();
  int totalLength = rhsLength + lhsLength;

  register int temp1;
  register int temp2;

  register int i;

  if (lhs.bounds.dirn() != rhs.bounds.dirn()) {
    cerr << "Strings are not legal to concatenate" << endl;
    abort();
  }

  //check whether left operand is a null array
  if ((lhsLeft > lhsRight) && (lhs.bounds.dirn() > 0)
      || (lhsLeft < lhsRight) && (lhs.bounds.dirn() < 0)) {
    return rhs;
    }
    else {
      //change rightbound
	VectorBase *tempStr = new VectorBase(0, lhs.bounds.dirn(), totalLength - 1);
      if(lhs.bounds.dirn() >  0) {
	temp1 = lhsLeft;
	temp2 = rhsLeft;
	for (  i = 0; i < totalLength; i++) {
	  if ( i < lhsLength) tempStr->ch[i] = lhs[temp1++];
	  else tempStr->ch[i] = rhs[temp2++];
				}
      }

      else { // The value of ArrayDirn_t is -1
	temp1 = lhsLeft;
	temp2 = rhsLeft;
	for (i = totalLength-1; i >=0; i--)
	  if ( i >= rhsLength)  {
	    tempStr->ch[i] = lhs[temp1--];
	  }
	  else { 
	    tempStr->ch[i] = rhs[temp2--];
	}
      }
      return *tempStr;
    }
  }
  

#endif
