#include "ArrayInfo.hh"
extern "C" {
  int abs(int);
}

const ArrayInfo defaultInfo(0, to, 0);

const ArrayInfo Others(1, to, 0);

const ArrayInfo nullInfo(0, to, -1);

ArrayInfo::ArrayInfo() : lbound(0), rbound(0), direction(to) {
}


ArrayInfo::ArrayInfo(int l, ArrayDirn_t d, int r) : lbound(l), rbound(r), direction(d){
}


ArrayInfo::ArrayInfo(const ArrayInfo& ai): lbound(ai.lbound), 
  rbound(ai.rbound), direction(ai.direction) {
}

// Returns the correct length, or 0 if null range.
int 
ArrayInfo::length() const {
  if(direction == to) {
    return(((rbound-lbound)>=0) ? (rbound-lbound+1) : 0);
  } else {
    return(((lbound-rbound)>=0) ? (lbound-rbound+1) : 0);
  }    
}


bool
ArrayInfo::operator==(const ArrayInfo& a) const {
  if (rbound != a.rbound || lbound != a.lbound || direction != a.direction) {
    return false;
  }
  return true;
}

bool
ArrayInfo::is_null_range() {
  return INT_TO_BOOL((direction == to) ? (lbound > rbound): (lbound < rbound));
}

bool
ArrayInfo::operator!=(const ArrayInfo& a) const {
  return INT_TO_BOOL(!(*this == a));
}


ArrayInfo&
ArrayInfo::operator=(const ArrayInfo& a) {
  lbound = a.lbound;
  rbound = a.rbound;
  direction = a.direction;
  return *this;
}


bool
ArrayInfo::contains(int index) const {

  if (direction == to && index >= lbound && index <= rbound) {
    return true;
  }
  if (direction == downto && index <= lbound && index >= rbound) {
    return true;
  }
  if (direction != to && direction != downto) {
    cerr << "Invalid direction! " << *this << endl;
    abort();
  }
  return false;
}


int
ArrayInfo::storageIndex(int arrayIndex) const {
  int retval;

#ifdef DEVELOPER_ASSERTIONS
  if (!contains(arrayIndex)) {
    cerr << "ArrayInfo::storageIndex: " << arrayIndex << " not in " 
	 << *this << endl;
    abort();
  }
#endif

  if (direction == to) {
    retval = arrayIndex - lbound;
  }
  else {
    retval = abs(arrayIndex - lbound);
  }
  return retval;
}

int
ArrayInfo::actualIndex(int positionalIndex) const {
  int retval;

  if (direction == to) {
    retval = lbound + positionalIndex;
  }
  else {
    retval = lbound - positionalIndex;
  }
  return retval;
}
