#include "list.hh"
#include "iterator.hh"
#include "list_object.hh"
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

void 
list::reset_data(){
  head = NULL;
  tail = NULL;

  iterator_array = NULL;
  iterator_array_size = -1;
  num_iterators = -1;
  num_elements = 0;
}

list::list( iterator *first_iterator ){
  reset_data();
  register_iterator( first_iterator );
}

void 
list::register_iterator( iterator *new_iterator ){
  if( num_iterators == iterator_array_size ){
    // Then we need to grow the array...
    if( iterator_array_size == -1 ){
      // Then it hasn't been initialized yet...
      iterator_array = new iterator *[INIT_ARRAY_SIZE];
      iterator_array_size = INIT_ARRAY_SIZE;
      num_iterators++;
    }
    else{
      int new_size = 2*iterator_array_size;
      iterator **temp_array = new iterator *[new_size];

      memcpy( temp_array, iterator_array, iterator_array_size*sizeof( iterator * ) );
      delete [] iterator_array;

      iterator_array = temp_array;
      iterator_array_size = new_size;
    }
  }

  // Now we are guaranteed to have an array big enough to hold our
  // new pointer too...
  num_iterators++;
  iterator_array[ num_iterators - 1 ] = new_iterator;  
}

void
list::remove_iterator( iterator *to_remove ){
  if( iterator_array[ num_iterators - 1 ] != to_remove ){
    cerr << "Must remove iterators in the order they were registered!" << endl;
    abort();
  }
  iterator_array[ num_iterators - 1 ] = NULL;
  num_iterators--;
}

void 
list::removing_element( list_object *removing ){
  int i;
  for( i = 0; i < num_iterators; i++ ){
    iterator_array[i]->get_off_of( removing );
  }

  if( removing == head ){
    // it's safe to assume we're not removing NULL elements
    list_object *new_head = head->get_next();
    if( new_head == head ){
      head = NULL;
    }
    else{
      head = new_head;
    }
  }
  if( removing == tail ){
    list_object *new_tail = tail->get_previous();
    if( new_tail == tail ){
      tail = NULL;
    }
    else{
      tail = new_tail;
    }
  }

  num_elements--;
}

void 
list::append( list_object *to_append ){
  switch( get_num_elements() ){
  case 0:
    // The list was empty...
    to_append->set_previous( to_append );
    to_append->set_next( to_append );

    set_head( to_append );
    set_tail( to_append );

    break;
    
  case 1:
    // There was only one element...

    to_append->set_previous( get_head() );
    to_append->set_next( get_head() );
    
    get_head()->set_next( to_append );
    get_head()->set_previous( to_append );
    set_tail( to_append );

    break;

  default:
    // The general case...
    to_append->set_next( get_head() );
    to_append->set_previous( get_tail() );

    get_tail()->set_next( to_append );
    get_head()->set_previous( to_append );
    set_tail( to_append );
  }

  new_element();
}

void 
list::prepend( list_object *to_prepend ){
  switch( get_num_elements() ){
  case 0:
    // The list was empty...
    to_prepend->set_previous( to_prepend );
    to_prepend->set_next( to_prepend );

    set_head( to_prepend );
    set_tail( to_prepend );

    break;
    
  case 1:
    // There was only one element...

    to_prepend->set_previous( get_head() );
    to_prepend->set_next( get_head() );
    
    get_head()->set_next( to_prepend );
    get_head()->set_previous( to_prepend );
    set_head( to_prepend );

    break;

  default:
    // The general case...
    to_prepend->set_next( get_head() );
    to_prepend->set_previous( get_tail() );

    get_tail()->set_next( to_prepend );
    get_head()->set_previous( to_prepend );
    set_head( to_prepend );
  }

  new_element();
}
