// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PredAttribute.cc,v 1.3 1999/09/29 13:55:32 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_PredAttribute.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_FunctionDeclaration.hh"

IIRScram_PredAttribute::~IIRScram_PredAttribute() {}

void 
IIRScram_PredAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL && get_suffix() != NULL);

  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'PRED(";
  get_suffix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ") ";
}


void 
IIRScram_PredAttribute::_publish_cc() {
  _publish_cc_type_attribute("PRED", TRUE);
}

IIR_TextLiteral *
IIRScram_PredAttribute::_build_attribute_name() {
  char *name = "pred";
  return IIR_Identifier::get( name, strlen(name) );
}


IIR_TypeDefinition *
IIRScram_PredAttribute::_get_subtype(){
  return _get_prefix_subtype();
}

set<IIR_TypeDefinition> *
IIRScram_PredAttribute::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  return get_prefix()->_get_rval_set(constraint_function);
}

IIR_Declaration *
IIRScram_PredAttribute::_get_implicit_declaration( char *decl_name, IIR_TypeDefinition *decl_type){
  return _build_function_declaration( decl_name, decl_type );
}

void 
IIRScram_PredAttribute::_resolve_suffix_special(){
  _resolve_suffix_base_type_of_prefix();
}

