
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PhysicalUnit.cc,v 1.2 1999/03/09 20:55:54 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_PhysicalUnit.hh"
#include "IIR_Identifier.hh"
#include "IIR_PhysicalTypeDefinition.hh"
#include "set.hh"

IIRScram_PhysicalUnit::~IIRScram_PhysicalUnit(){
  my_type = NULL;
}

void 
IIRScram_PhysicalUnit::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "    ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " = ";
  get_multiplier()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_PhysicalUnit::_publish_cc() {
  //  _cc_out << *get_declarator();
  _get_physical_type()->_publish_cc_kernel_type();
  _cc_out << "(ObjectBase::VARIABLE, ";
  _publish_cc_value();
  _get_physical_type()->_publish_cc_object_type_info();
  _cc_out << ")";
}

void 
IIRScram_PhysicalUnit::_publish_cc_state_object_init() {
  _cc_out << "new ";
  _publish_cc();
}

void 
IIRScram_PhysicalUnit::_publish_cc_value() {
  int position_count = 0;
  IIR_PhysicalUnit *node = _get_physical_type()->get_primary_unit();
  
  if (IIR_TextLiteral::_cmp(_get_physical_type()->_get_declarator(), "time") == 0){
    ASSERT ( get_multiplier() != NULL );
    get_multiplier()->_publish_cc();
  }
  else {
    if ( (IIR_PhysicalUnit *)this == node){
      _get_physical_type()->_publish_cc();
      _cc_out << "_info.get_scale_info()[0]";
    }
    else {
      node = _get_physical_type()->units.first();
      while(node != (IIR_PhysicalUnit *)this){
	position_count++;
	node = _get_physical_type()->units.successor(node);
      }
      _get_physical_type()->_publish_cc();
      _cc_out << "_info.get_scale_info()[" << position_count + 1 << "]";
    }
  }
}

void 
IIRScram_PhysicalUnit::_publish_cc_universal_value() {
  _get_physical_type()->_publish_cc_universal_type(); 
  _cc_out << "(";
  _publish_cc_value();
  _cc_out << ")";
}

void 
IIRScram_PhysicalUnit::_publish_cc_headers() {
  _cc_out << "#include \"";
  _get_physical_type()->_publish_cc_type_name();
  _cc_out << ".hh\"" << endl;
}

void 
IIRScram_PhysicalUnit::_publish_cc_initialization_value() {
  _cc_out << "1 * ";
  _publish_cc_value();
}

IIRScram_Declaration::declaration_type 
IIRScram_PhysicalUnit::_get_type(){
  return UNITS;
}

IIR_PhysicalTypeDefinition *
IIRScram_PhysicalUnit::_get_physical_type(){
  return my_type;
}

void 
IIRScram_PhysicalUnit::_set_physical_type( IIR_PhysicalTypeDefinition *new_type){
  my_type = new_type;
}


IIR_TypeDefinition *
IIRScram_PhysicalUnit::_get_subtype(){
  return _get_physical_type();
}

set<IIR_TypeDefinition> *
IIRScram_PhysicalUnit::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  return new set<IIR_TypeDefinition>( _get_subtype() );
}

void
IIRScram_PhysicalUnit::_publish_cc_name() {
  //_cc_out << *get_declarator();
  _get_declarator()->_publish_cc();
}

void
IIRScram_PhysicalUnit::_publish_vhdl(ostream &_vhdl_out){
  get_declarator()->_publish_vhdl(_vhdl_out);
}
