// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EnumerationLiteralList.cc,v 1.2 1999/03/09 20:54:18 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_EnumerationLiteralList.hh"
#include "IIR_EnumerationLiteral.hh"

IIRScram_EnumerationLiteralList::~IIRScram_EnumerationLiteralList() {}


void 
IIRScram_EnumerationLiteralList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_EnumerationLiteral *literal;
    
    _vhdl_out << "(";
    
  literal = first();
  while (literal != NULL) {
    literal->_publish_vhdl(_vhdl_out);
    literal = successor(literal);
    if (literal != NULL) {
      _vhdl_out << ", ";
    }
  }
  _vhdl_out << ")";
}

ostream&
IIRScram_EnumerationLiteralList::_print(ostream& os) {
  _publish_vhdl( os );

  return os;
}

void 
IIRScram_EnumerationLiteralList::_publish_cc() {
  IIR_EnumerationLiteral *literal;
    
  literal = first();
  while (literal != NULL) {
    literal->_publish_cc();
    literal = successor(literal);
    if (literal != NULL) {
      _cc_out << ", ";
    }
  }
}


