// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Choice.cc,v 1.3 1999/10/26 16:44:39 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_Choice.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_Literal.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "set.hh"
#include <strstream.h>

class IIR_Declaration;


IIRScram_Choice::~IIRScram_Choice() {}


void 
IIRScram_Choice::_publish_vhdl(ostream &_vhdl_out) {
  get_value()->_publish_vhdl(_vhdl_out);
}


void 
IIRScram_Choice::_publish_cc() {
  //The publishing of choices will be organised once the way the
  // the different types of choices that will be returned by front-end
  // is known
  if(get_value()->get_kind() == IIR_ENUMERATION_LITERAL) {
    ((IIR_EnumerationLiteral*)get_value())->_publish_cc_condition();
  }
  else if(get_value()->_is_literal()) {
    ((IIR_Literal*)get_value())->_publish_cc_condition();
  }
  else if(get_value()->_is_subtype()) {
    //choice is a discrete range
    _publish_cc_discrete_range();
  }
  else {
    get_value()->_publish_cc();
  }
}


void 
IIRScram_Choice::_publish_cc_discrete_range() {
  //The publishing of choices will be organised once the way the
  // the different types of choices that will be returned by front-end
  // is known
  IIR_ScalarTypeDefinition* sub_type = (IIR_ScalarTypeDefinition*) get_value();


  _cc_out << " savantAnd(";
  if(sub_type->get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "savantGreaterThanOrEqual(";
  }
  else {
    _cc_out << "savantLessThanOrEqual(";
  }

  _current_publish_node->_publish_cc();
  _cc_out << ", ";
  sub_type->get_left()->_publish_cc();
  _cc_out << "), "; 
  
  if(sub_type->get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "savantLessThanOrEqual(";
  }
  else {
    _cc_out << "savantGreaterThanOrEqual(";
  }

  _current_publish_node->_publish_cc();
  _cc_out << ", ";
  sub_type->get_right()->_publish_cc();
  _cc_out << ")))";
}


set<IIR_TypeDefinition> *
IIRScram_Choice::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  ASSERT( get_value() != NULL );
  return get_value()->_get_rval_set(constraint_function);
}


IIR *
IIRScram_Choice::_rval_to_decl( IIR_TypeDefinition *my_typedef ){
//   if( my_typedef->_is_array_type() == TRUE ){
//     if( get_value()->get_kind() == IIR_SIMPLE_NAME ){
//       ostrstream err;
//       err << "Simple name choices are only allowed for record aggregates." << ends;
//       report_error( this, err );
//     }
//   }
//   else{
//     if( get_value()->get_kind() != IIR_SIMPLE_NAME ){
//       ostrstream err;
//       err << "Record aggregates should have simple name choices." << ends;
//       report_error( this, err );      
//     }
//   }
  set_value( get_value()->_rval_to_decl( my_typedef ) );
  return (IIR *)this;
}


void
IIRScram_Choice::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list){
  get_value()->_build_sensitivity_list(sensitivity_list);
}


set<IIR_Declaration> *
IIRScram_Choice::_symbol_lookup(){
  return get_value()->_symbol_lookup();
}


ostream &
IIRScram_Choice::_print( ostream &os ){
  os << *get_value();
  return os;
}


void 
IIRScram_Choice::_type_check( set<IIR_TypeDefinition> *context_set ){
  set_value( get_value()->_semantic_transform( context_set ) );
  get_value()->_type_check( context_set );
  
  set<IIR_TypeDefinition> *choice_rvals = get_value()->_get_rval_set();
  
  if( choice_rvals == NULL ){
    report_undefined_symbol( get_value() );
  }

  reconcile_sets( context_set, choice_rvals );
  switch( context_set->num_elements() ){
  case 0:{
    ostrstream err;
    err << "Choice |" << get_value() << " is not of expected type." << ends;
    break;
  }
  case 1:{
    IIR_TypeDefinition *my_type = context_set->get_element();
    set_value( get_value()->_rval_to_decl( my_type ) );
    break;
  }
  default:
    report_ambiguous_error( get_value(), choice_rvals );
  }
  delete choice_rvals;
}


IIR_Boolean 
IIRScram_Choice::_is_resolved(){
  return get_value()->_is_resolved();
}

IIR*
IIRScram_Choice::_clone() {
  return this;
}
