
#ifndef IIRSCRAM_AGGREGATE_HH
#define IIRSCRAM_AGGREGATE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Aggregate.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_Aggregate.hh"
class ostream;
template <class type> class set;
class IIR_DesignatorList;

class IIRScram_Aggregate : public IIRBase_Aggregate {

public:

  void _publish_vhdl(ostream &);
  ostream &_print( ostream & );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  void _type_check( set<IIR_TypeDefinition> * );

  IIR *_rval_to_decl( IIR_TypeDefinition * );

  IIR_Boolean _is_resolved( );
  IIR_Boolean _is_signal( );
  IIR_Boolean _is_variable( );
  IIR_Boolean _is_aggregate_expression(){ return TRUE; }

  IIR_Boolean _is_readable( );
  IIR_Boolean _is_writable( );

  IIR_Declaration* _get_prefix_declaration();

  void _publish_cc();
  void _publish_cc_element_list();
  void _publish_cc_range();
  void _publish_cc_multi_dimensional_range();
  void _publish_cc_state_object_init();
  void _publish_cc_initialization_value();
  void _publish_cc_constructor_args();

  void _add_decl_into_cgen_symbol_table();

  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _get_signal_source_info(set<IIR_Declaration>* siginfo);
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  IIR_TypeDefinition *_get_subtype();
  // In an aggregate initialization, the associationlist has the list of
  // initializations. But there can be many initializations specified by
  // IIR_CaseAlternativeByChoices, so this function returns the number of
  // elemenst that are explicitly initialized, by considering the number of
  // iniatializations by choices as that many number of initializations.
  IIR_Int32 _get_number_of_element_associations();

  IIR *_clone();

  IIR_Boolean _is_globally_static_primary();

protected:
  
  IIRScram_Aggregate(){ my_rval = NULL; };
  virtual ~IIRScram_Aggregate() = 0;
    
private:

  void _rval_to_decl_process_named_part( IIR_TypeDefinition *, IIR_AssociationElement * );

  IIR_TypeDefinition *my_rval;
};

#endif
