// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran  urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ActiveAttribute.cc,v 1.4 1999/10/28 03:24:04 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_ActiveAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_EnumerationTypeDefinition.hh"
#include "StandardPackage.hh"

IIRScram_ActiveAttribute::~IIRScram_ActiveAttribute() {}

void 
IIRScram_ActiveAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'ACTIVE ";
}


IIR_TextLiteral *
IIRScram_ActiveAttribute::_build_attribute_name() {
  char *name = "active";
  return IIR_Identifier::get( name, strlen(name) );
}

// The active attribute is a boolean function valued attribute...
IIR_TypeDefinition *
IIRScram_ActiveAttribute::_get_subtype(){
  return StandardPackage::boolean_type;
}

IIR_Declaration *
IIRScram_ActiveAttribute::_get_implicit_declaration( char *decl_name,
						     IIR_TypeDefinition *decl_type ){
  return _build_signal_declaration( decl_name, decl_type );
}


void 
IIRScram_ActiveAttribute::_publish_cc() {
  _publish_cc_signal_attribute("Active");
}

void
IIRScram_ActiveAttribute::_publish_cc_necessary_decl_in_state() {
  _publish_cc_necessary_signal_decl_in_state(LAST_ACTIVE, "_last_active");
  _publish_cc_necessary_signal_decl_in_state(ACTIVE, "_active");
}

// Initialization value of the signal, in UserState::initstate()
void
IIRScram_ActiveAttribute::_publish_cc_init_val() { 
  _cc_out << "true";
}

void
IIRScram_ActiveAttribute::_publish_cc_name_in_caps() {
  _cc_out << "ACTIVE";
}

void
IIRScram_ActiveAttribute::_publish_cc_attrib_type() {
  _cc_out << "function";
}


void
IIRScram_ActiveAttribute::_publish_cc_necessary_decl_init() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );

  _publish_cc_necessary_signal_init(LAST_ACTIVE, "_last_active");
}


void
IIRScram_ActiveAttribute::_publish_cc_elaborate() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_cc_elaborate();
  _cc_out << "_active";
}


void
IIRScram_ActiveAttribute::_publish_cc_sigtype() {
  _cc_out << " I_ACTIVE;\n";
}


void
IIRScram_ActiveAttribute::_publish_cc_state_object_init() {
  _publish_cc_necessary_signal_state_object_init(LAST_ACTIVE, "_last_active");
  _publish_cc_necessary_signal_state_object_init(ACTIVE, "_active", TRUE);
}

void
IIRScram_ActiveAttribute::_publish_cc_init() {
  _publish_cc_necessary_signal_init(LAST_ACTIVE, "_last_active");
  _publish_cc_necessary_signal_init(ACTIVE, "_active", TRUE);
}

void
IIRScram_ActiveAttribute::_publish_cc_necessary_copying() {
  _publish_cc_necessary_attribute_copying(LAST_ACTIVE, "_last_active");
  _publish_cc_necessary_attribute_copying(ACTIVE, "_active");
}

void
IIRScram_ActiveAttribute::_publish_cc_read_or_write(const char *functionName, const char *streamName) {
  _publish_cc_attribute_read_or_write(LAST_ACTIVE, "_last_active", functionName, streamName);
  _publish_cc_attribute_read_or_write(ACTIVE, "_active", functionName, streamName);
}


IIR*
IIRScram_ActiveAttribute::_clone() {
  IIR_ActiveAttribute *clone = new IIR_ActiveAttribute;
  IIR_Attribute::_clone(clone);
  return clone;
}
