
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_DesignFileList.cc,v 1.2 1999/03/09 20:49:30 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_DesignFileList.hh"
#include "IIR_DesignFile.hh"

IIRBase_DesignFileList::IIRBase_DesignFileList(){}

IIRBase_DesignFileList::~IIRBase_DesignFileList(){}

IIR_DesignFile *
IIRBase_DesignFileList::successor( IIR_DesignFile *to_succeed ){
  if( to_succeed != NULL ){
    ASSERT( to_succeed->get_kind() == IIR_DESIGN_FILE );
  }

  IIR *retval = IIR_List::successor( (IIR *)to_succeed );

  if( retval != NULL ){
    ASSERT( retval->get_kind() == IIR_DESIGN_FILE ); 
  }

  return (IIR_DesignFile *)retval;
}

IIR_DesignFile *
IIRBase_DesignFileList::predecessor( IIR_DesignFile *to_precede ){
  if( to_precede != NULL ){
    ASSERT( to_precede->get_kind() == IIR_DESIGN_FILE );
  }

  IIR *retval = IIR_List::predecessor( (IIR *)to_precede );

  if( retval != NULL ){
    ASSERT( retval->get_kind() == IIR_DESIGN_FILE );
  }
  
  return (IIR_DesignFile *)retval;
}

IIR_DesignFile *
IIRBase_DesignFileList::first( ){
  IIR *retval = IIR_List::first( );

  if( retval != NULL ){
    ASSERT( retval->get_kind() == IIR_DESIGN_FILE );
  }

  return (IIR_DesignFile *)retval;
}

void 
IIRBase_DesignFileList::append( IIR_DesignFile *to_append ){
  ASSERT( to_append->get_kind() == IIR_DESIGN_FILE );
  IIR_List::append( (IIR *)to_append );
}

void
IIRBase_DesignFileList::prepend( IIR_DesignFile *to_prepend ){
  ASSERT( to_prepend->get_kind() == IIR_DESIGN_FILE );
  IIR_List::prepend( (IIR *)to_prepend );
}

