/*$Id: s__out.cc,v 14.12 1999/07/23 10:13:54 al Exp $ -*- C++ -*-
 * tr,dc analysis output functions (and some ac)
 */
#include "constant.h"
#include "u_prblst.h"
#include "declare.h"	/* plottr, plopen */
#include "u_status.h"
#include "s__.h"
/*--------------------------------------------------------------------------*/
//	PROBELIST& SIM::alarmlist()
//	PROBELIST& SIM::plotlist()
//	PROBELIST& SIM::printlist()
//	PROBELIST& SIM::storelist()
//	void	SIM::outdata(double);
//	void	SIM::head(double,double,bool,const char*);
//	void	SIM::print(double);
//	void	SIM::alarm(void);
//	void	SIM::store(void);
/*--------------------------------------------------------------------------*/
/* SIM::____list: access probe lists
 */
PROBELIST& SIM::alarmlist()
{
  return PROBE_LISTS::alarm[mode];
}
PROBELIST& SIM::plotlist()
{
  return PROBE_LISTS::plot[mode];
}
PROBELIST& SIM::printlist()
{
  return PROBE_LISTS::print[mode];
}
PROBELIST& SIM::storelist()
{
  return PROBE_LISTS::store[mode];
}
/*--------------------------------------------------------------------------*/
/* SIM::out: output the data, "keep" for ac reference
 */
void SIM::outdata(double x)
{
  STATUS::output.start();
  plottr(x);
  print(x);
  alarm();
  store();
  STATUS::iter[iPRINTSTEP] = 0;
  STATUS::control[cSTEPS] = 0;
  STATUS::output.stop();
}
/*--------------------------------------------------------------------------*/
/* SIM::head: print column headings and draw plot borders
 */
void SIM::head(double start, double stop, bool linear, const char *col1)
{
  if (!plopen(mode,start,stop,linear)){
    // ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    if (col1  &&  *col1){
      out.form("#%-10s", col1);
    }else{
      untested();
    }
    for (PROBELIST::const_iterator
	   p=printlist().begin();  p!=printlist().end();  ++p){
      out.form(" %-10.10s", p->label().c_str());
    }
    out << '\n';
  }
}
/*--------------------------------------------------------------------------*/
/* SIM::print: print the list of results (text form) to out
 * The argument is the first column (independent variable, aka "x")
 */
void SIM::print(double x)
{
  if (!IO::plotout.any()){
    out.setfloatwidth(5,11);
    if (x != NOT_VALID){
      out << x;
    }else{
      untested();
    }
    for (PROBELIST::const_iterator
	   p=printlist().begin();  p!=printlist().end();  ++p){
      out << p->value();
    }
    out << '\n';
  }
}
/*--------------------------------------------------------------------------*/
/* SIM::alarm: print a message when a probe is out of range
 */
void SIM::alarm(void)
{
  out.setfloatwidth(5,11);
  for (PROBELIST::const_iterator
	 p=alarmlist().begin();  p!=alarmlist().end();  ++p){
    if (!p->inrange()){
      out << p->label() << '=' << p->value() << '\n';
    }
  }
}
/*--------------------------------------------------------------------------*/
/* SIM::store: a stub: will be store data in preparation for post processing
 */
void SIM::store(void)
{
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
