/*$Id: findbr.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * find a branch with matching label
 * returns the branch pointer
 */
#include "ap.h"
#include "l_lib.h"
#include "e_card.h"
/*--------------------------------------------------------------------------*/
/* findbranch: find a matching label, by (ugh) linear search
 * 	start searching at "start", stop at "stop"
 *	label to look for is in command line: &cmd[*cnt]
 * return pointer to match if exists (and eat input)
 *	  pointer to a non-existent branch if no match (don't eat input)
 * caution: caller must check return value before using
 */
CARD_LIST::fat_iterator findbranch(CS& cmd, CARD_LIST::fat_iterator here)
{
  int save = cmd.cursor();

  char labelwanted[BUFLEN+1];
  cmd.ctostr(labelwanted, BUFLEN, TOKENTERM);
  
  if (!labelwanted[0] /*|| !labelwanted[1]*/){
    cmd.reset(save);			// don't match single letter
    return here.end();			// why not???
  }	// it MUST match single letter because it is possible to
	// accidentally enter a label with a single letter.
  
  char* wanted = NULL;
  char* dot = strrchr(labelwanted,'.');
  if (dot){		// split the string into 2 parts at the last dot
    *dot = '\0';	// before is the new "labelwanted", shortened
    wanted = dot + 1;	// "wanted" is the last part .. the top part
  }else{
    wanted = labelwanted;
  }

  for (;;){
    if (here.isend()){	// done -- fails
      cmd.reset(save);
      return here;
    }
    if (wmatch((**here).short_label().c_str(),wanted)){ // the label matches
      {if (!dot){ // there is no dot in the name .. found it .. done.
	return here;
      }else if((**here).subckt().exists()){ // this one has a subckt .. try it
	CS want(labelwanted);
	CARD_LIST::fat_iterator subbrh = findbranch(want, &(**here).subckt());
	if (!subbrh.isend()){ // found it in a subckt
	  return subbrh;
	}
      }else{ 
	// there's a dot in the name (which matches), no subckt
	// .. not it .. try again
	untested();
      }}
    }
    ++here;
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
