/*$Id: e_ccsrc.cc,v 15.11 1999/10/14 07:46:49 al Exp $ -*- C++ -*-
 * current controlled source base
 */
#include "ap.h"
#include "e_ccsrc.h"
/*--------------------------------------------------------------------------*/
//	ELEMENT& CCSRC_BASE::parse_more_nodes(CS& cmd, int);
//	void	 CCSRC_BASE::print(int,int)const;
/*--------------------------------------------------------------------------*/
void CCSRC_BASE::parse_more_nodes(CS& cmd, int)
{
  _input_label = cmd.ctos(TOKENTERM);
  _input_label[0] = toupper(_input_label[0]);
}
/*--------------------------------------------------------------------------*/
void CCSRC_BASE::print(OMSTREAM where, int /*detail*/)const
{
  where << short_label();
  printnodes(where,PRINTNODES);
  where << "  ";

  {if (_input){ // has been expanded
    where << _input->short_label();
  }else{ // not expanded
    where << _input_label;	/* could always print as not expanded, */
  }}				/* but this way provides error check   */
  
  if (!has_common() || value() != 0){
    where << ' ' << value();
  }
  if (has_common()){
    common()->print(where);
  }
  where << '\n';
}
/*--------------------------------------------------------------------------*/
void CCSRC_BASE::expand()
{
  {if (!_input_label.empty()){
    _input = dynamic_cast<ELEMENT*>(find_in_scope(_input_label));
  }else{
    // _input already set, an internal element.  example: mutual L.
  }}
  if (!_input || _input->is_2port() || _input->subckt().exists()){
    error(bERROR, long_label() + ": " + _input_label
	  + " cannot be used as current probe\n");
  }
  {if (_input->is_2port()){
    unreachable();
    n[IN1] = _input->n[IN1];
    n[IN2] = _input->n[IN2];
  }else{
    assert(_input->is_1port()  ||  _input->is_source());
    n[IN1] = _input->n[OUT1];
    n[IN2] = _input->n[OUT2];
  }}
  n[IN1].e = n[IN2].e = INVALIDNODE;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
