/*$Id: e_card.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * Base class for "cards" in the circuit description file
 */
#include "ap.h"
#include "e_card.h"
/*--------------------------------------------------------------------------*/
//		CARD::CARD();
//		CARD::CARD(const CARD& proto);
//	CARD&	CARD::set_Label(const std::string& s);
//	CARD&	CARD::parse_label(CS& cmd);
//	CARD&	CARD::parse_Label(CS& cmd);
//	double	CARD::probe(const CARD*,const std::string&);
// 	int	CARD::connects_to(int node)const;
/*--------------------------------------------------------------------------*/
double CARD::initial_condition = NOT_INPUT;
const int POOLSIZE = 4;
/*--------------------------------------------------------------------------*/
CARD::CARD()
  :CKT_BASE(),
   _evaliter(0),
   _subckt(),
   _owner(0),
   _label(),
   _value(0),
   _constant(false)
{
  for (int ii = 0;  ii <= NODESPERBRANCH;  ii++)
    _nodes[ii].e = _nodes[ii].t = _nodes[ii].m = INVALIDNODE;
  n = _nodes;
}
/*--------------------------------------------------------------------------*/
CARD::CARD(const CARD& p)
  :CKT_BASE(p),
   _evaliter(0),
   _subckt(), // BUG:: isn't this supposed to copy????
   _owner(0),
   _label(p._label),
   _value(p._value),
   _constant(p._constant)
{
  for (int ii = 0;  ii <= NODESPERBRANCH;  ii++)
    _nodes[ii] = p._nodes[ii];
  n = _nodes;
}
/*--------------------------------------------------------------------------*/
void CARD::set_Label(const std::string& s)
{
  set_label(s);
  _label[0] = toupper(_label[0]);
}
/*--------------------------------------------------------------------------*/
void CARD::parse_label(CS& cmd)
{
  set_label(cmd.ctos(TOKENTERM));
  //if (_label.length() < 2){
  //  cmd.warn(bPICKY);
  //}
}
/*--------------------------------------------------------------------------*/
void CARD::parse_Label(CS& cmd)
{
  parse_label(cmd);
  _label[0] = toupper(_label[0]);
}
/*--------------------------------------------------------------------------*/
const std::string CARD::long_label()const
{
  std::string buffer(short_label());
  for (const CARD* brh = owner(); exists(brh); brh = brh->owner()){
    buffer += '.' + brh->short_label();
  }
  return buffer;
}
/*--------------------------------------------------------------------------*/
/*static*/ double CARD::probe(const CARD *This, const std::string& what)
{
  if (exists(This)){
    return This->probe_num(what);
  }else{				/* return 0 if doesn't exist */
    return 0.0;				/* happens when optimized models */
  }					/* don't have all parts */
}
/*--------------------------------------------------------------------------*/
/* connects_to: does this part connect to this node?
 * input: a node
 * returns: how many times this part connects to it.
 * does not traverse subcircuits
 */
int CARD::connects_to(int node)const
{
  int count = 0;
  if (is_device()){
    for (int ii = 0;  n[ii].t != INVALIDNODE;  ii++){
      if (node == n[ii].t)
        ++count;
    }
  }
  return count;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
