/*$Id: d_vcvs.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * functions for vcvs
 * temporary kluge: it has resistance
 */
#include "d_vcvs.h"
/*--------------------------------------------------------------------------*/
void DEV_VCVS::precalc()
{
  loss = 1./OPT::shortckt;
  y0.f0 = LINEAR;
  y0.f1 = value();
  y1 = y0;
  m0.c1 = -loss * y0.f1;
  m0.c0 = 0.;
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_VCVS::dc_begin()
{
  loss = 1./OPT::shortckt;
  if (!has_tr_eval()){
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    m0.c1 = -loss * y0.f1;
    assert(m0.c0 == 0.);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_VCVS::do_tr()
{
  {if (has_tr_eval()){
    m0.x = volts_limited(n[IN1],n[IN2]);
    y0.x = m0.x;
    tr_eval();
    assert(y0.f0 != LINEAR);
    store_values();
    q_load();
    m0 = CPOLY1(y0);
    m0 *= -loss;
  }else{
    untested();
    assert(loss == 1./OPT::shortckt);
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    assert(m0.c1 == -loss * y0.f1);
    assert(m0.c0 == 0.);
    assert(y1 == y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_VCVS::do_ac()
{
  ac_load_loss();
  {if (has_ac_eval()){
    ac_eval();
    acg = -loss * ev;
  }else{
    assert(ev == y0.f1);
    assert(has_tr_eval() || ev == value());
  }}
  //assert(acg == -loss * ev); fails due to rounding
  ac_load_active(); 
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
