/*$Id: d_mos6.cc,v 15.10 1999/10/11 06:30:33 al Exp $ -*- C++ -*-
 * mos model equations: spice level 6 equivalent.
 * Derived from Spice 3f4.
 *     this block of code evaluates the drain current and its 
 *     derivatives using the n-th power MOS model and the 
 *     charges associated with the gate, channel and bulk for 
 *     mosfets
 */
#include "ap.h"
#include "d_mos6.h"
/*--------------------------------------------------------------------------*/
//		MODEL_MOS6::MODEL_MOS6()
//	void	MODEL_MOS6::parse_params(CS& cmd)
//	void	MODEL_MOS6::post_parse()
//	void	MODEL_MOS6::print(OMSTREAM where, int)const
//	void	MODEL_MOS6::tr_eval(COMPONENT*)const;
/*--------------------------------------------------------------------------*/
const double DEFAULT_kc = 5e-5;
/*--------------------------------------------------------------------------*/
MODEL_MOS6::MODEL_MOS6()
{
  kv      = 2.0;
  nv      = 0.5;
  kc      = NOT_INPUT;
  nc      = 1.0;
  nvth    = 0.5;
  ps      = 0.0;
  gamma1  = 0.0;
  sigma	  = 0.0;
  lambda1 = 0.0;
  calc_kc = false;

  lambda = 0.0; // override 123 default
  cmodel = 3;
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS6::parse_params(CS& cmd)
{
  parse_params_123(cmd);
  cmd.get("KV", &kv);
  cmd.get("NV", &nv);
  cmd.get("KC", &kc);
  cmd.get("NC", &nc);
  cmd.get("NVTH", &nvth);
  cmd.get("PS", &ps);
  cmd.get("GAMMA1", &gamma1);
  cmd.get("SIGMA", &sigma);
  cmd.get("LAMBDA0", &lambda);
  cmd.get("LAMBDA1", &lambda1);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS6::post_parse()
{
  post_parse_123();
  if (cox == NOT_INPUT){
    cox = 0.;
  }
  if (cox > 0){
    if (calc_kc || kc == NOT_INPUT){
      kc = .5 * uo * cox;
      calc_kc = true;
    }else{
      untested();
    }
  }
  if (kc == NOT_INPUT){
    kc = DEFAULT_kc;
  }
  trace3("", uo, cox, kc);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS6::print(OMSTREAM where, int)const
{
  print_123_begin(where,LEVEL);
  where   << "  kv="	<< kv;
  where   << "  nv="	<< nv;
  if (!calc_kc)
    where << "  kc="	<< kc;
  where   << "  nc="	<< nc;
  where   << "  nvth="	<< nvth;
  where   << "  ps="	<< ps;
  where   << "  gamma1="<< gamma1;
  where   << "  sigma="	<< sigma;
  where   << "  lambda0="<< lambda;
  where   << "  lambda1="<< lambda1;
  print_123_mid(where);
  if (calc_kc)
    where << "* kc="	<< kc;
  print_123_end(where);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS6::tr_eval(COMPONENT* brh)const
{
  DEV_MOS* d = prechecked_cast<DEV_MOS*>(brh);
  assert(d);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(d->common());
  assert(c);
  const MODEL_MOS6* m = this;
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
  trace1(d->long_label(), d->evaliter());
  trace3("", d->vds, d->vgs, d->vbs);
  assert(m->_tnom > 0);
  assert(m->egap != NOT_VALID);
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
  double temp = SIM::temp;
  double tempratio  = temp / m->_tnom; // ratio
  double tempratio4 = tempratio * sqrt(tempratio);
  double vt = temp * K / Q;
  double kt = temp * K;
  double t_egap = 1.16 - (7.02e-4*temp*temp) / (temp+1108.);

  double arg = (m->egap*tempratio - t_egap) / (2*kt);
  double pfcf = -2*vt * (1.5*log(tempratio) + Q*(arg));
  double t_phi = m->phi * tempratio + pfcf; //?????????
  double t_sqrt_phi = sqrt(t_phi);
  double t_kc   = m->kc * tempratio4;
  double t_beta = t_kc * c->we / c->le;
  double t_vbi = m->vbi +.5*(m->egap-t_egap) + m->polarity*.5*(t_phi-m->phi);
  trace4("T", t_phi, t_kc, t_beta, t_vbi);
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
  double sarg;
  if (d->vbs <= 0.){
    sarg = sqrt(t_phi - d->vbs);
  }else{
    sarg = sqrt(t_phi);
    sarg = sarg - d->vbs / (sarg+sarg);
    if (sarg < 0.){
      untested();
      sarg = 0.;
    }else{
      untested();
    }
  }
  trace3("", t_phi, d->vbs, sarg);
  assert(sarg >= 0.);
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
  trace4("", d->vds, t_vbi, m->gamma, m->gamma1);
  d->von = t_vbi * m->polarity + m->gamma * sarg - m->gamma1 * d->vbs;
  // - m->sigma  * d->vds;  // what is this?????
  d->vgst = d->vgs - d->von;
  trace3("", d->vds, d->von, d->vgst);
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
  d->cutoff = (d->vgst <= 0.);
  if (d->cutoff){
    d->vdsat = 0.;
    d->ids = d->gm = d->gds = d->gmb = 0.;
    trace4("cut", d->ids, d->gm, d->gds, d->gmb);
  }else{
    double vonbm;
    if (d->vbs <= 0.){
      vonbm = m->gamma1	+ m->gamma / (sarg + sarg);
    }else{
      vonbm = m->gamma1	+ m->gamma * .5 / t_sqrt_phi;
      untested();
    }
    trace3("", m->nc, m->lambda, m->lambda1);
    double logvgon = log(d->vgst);
    double idsat = t_beta * exp(logvgon * m->nc);
    double Lambda = m->lambda - m->lambda1 * d->vbs;
    trace4("", vonbm, logvgon, idsat, Lambda);

    d->ids = idsat * (1 + Lambda * d->vds);
    d->gm  = d->ids * m->nc / d->vgst;
    d->gds = d->gm * m->sigma + idsat * Lambda;
    d->gmb = d->gm * vonbm - idsat * m->lambda1 * d->vds;

    d->vdsat = m->kv * exp(logvgon * m->nv);
    trace4("sat", d->ids, d->gm, d->gds, d->gmb);

    d->saturated = (d->vdsat <= d->vds);
    if (!d->saturated){
      double vdst   = d->vds / d->vdsat;
      double vdst2  = (2 - vdst) * vdst;
      double vdstg  = - vdst * m->nv / d->vgst;
      double ivdst1 = d->ids * (2 - vdst - vdst);
      d->ids *= vdst2;
      d->gm  = d->gm  * vdst2 + ivdst1 * vdstg;
      d->gds = d->gds * vdst2 + ivdst1 * (1 / d->vdsat + vdstg * m->sigma);
      d->gmb = d->gmb * vdst2 + ivdst1 * vdstg * vonbm;
      trace4("lin", d->ids, d->gm, d->gds, d->gmb);
    }else{
      untested();
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
