/*$Id: c_nodset.cc,v 15.3 1999/09/17 17:27:00 al Exp $ -*- C++ -*-
 * nodeset and ic commands
 */
#include "ap.h"
#include "c_comand.h"
#include "c_nodset.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::ic(CS&);
//	void	CMD::nodeset(CS&);
//	void	NODESET::command(CS&,NODESET*);
//	void	NODESET::add_list(CS&);
//	void	NODESET::add1(int,double);
//	void	NODESET::rm_all()
//	void	NODESET::rm1(int);
//	void	NODESET::list_all()const
//	void	NODESET::list1()const
/*--------------------------------------------------------------------------*/
static NODESET iclist;
static NODESET nslist;
/*--------------------------------------------------------------------------*/
void CMD::ic(CS& cmd)
{
  iclist.command(cmd);
}
/*--------------------------------------------------------------------------*/
void CMD::nodeset(CS& cmd)
{
  nslist.command(cmd);
}
/*--------------------------------------------------------------------------*/
void NODESET::command(CS& cmd)
{
  if (cmd.end()){
    untested();
    list_all();
  }else if (cmd.pmatch("CLEAR")){
    rm_all();
  }else{
    untested();
    add_list(cmd);
  }
}
/*--------------------------------------------------------------------------*/
/* add_list: add a bunch of nodes
 */
void NODESET::add_list(CS& cmd)
{
  untested();
  while (cmd.pmatch("V")){
    int paren = cmd.skiplparen();
    int node = cmd.ctoi();
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.check(bWARNING, "need )");
    }
    cmd.skipequal();
    int mark = cmd.cursor();
    double voltage = cmd.ctof();
    if (mark == cmd.cursor()){		/* no voltage value = unset */
      _m.erase(node);
    }else{
      _m[node] = voltage;
    }
  }
  cmd.check(bWARNING, "what's this?");
}
/*--------------------------------------------------------------------------*/
/* rm_all: unset all nodes
 * but leave top allocated
 */
void NODESET::rm_all()
{
  _m.erase(_m.begin(), _m.end());
}
/*--------------------------------------------------------------------------*/
/* list_all: list all nodes set
 */
void NODESET::list_all()const
{
  untested();
  for (std::map<int, double>::const_iterator
	 i = _m.begin(); i != _m.end(); ++i){
    IO::mstdout.setfloatwidth(7) << "  V(" << i->first << ")=" << i->second;
  }
  IO::mstdout << '\n';	
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
