/*$Id: ap_match.cc,v 14.13 1999/08/01 03:34:53 al Exp $ -*- C++ -*-
 * string compare
 * compares characters until end of first string
 * any non-alpha character may be a terminator
 * Characters in reference string in UPPER case must match.
 * Always requires at least one character to match.
 */
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	CS&	CS::pmatch(const std::string&);
//	CS&	CS::pscan(const std::string&);
/*--------------------------------------------------------------------------*/
CS& CS::pmatch(const std::string& s)
{
  int start = cursor();
  skipbl();
  int tokenstart = cursor();

  const char* str2 = s.c_str();
  while (*str2 && tolower(peek()) == tolower(*str2)){ // as far as you can
    skip();
    ++str2;
  }
  // something didn't match -- let's see what and why
  {if (strcmp(str2,"$$")==0){ // stop marker in reference -- accept
    skipcom();
    _ok = true;
  }else if (cursor() == tokenstart // didn't move
	    || is_alpha()	   // more letters in the string being tested
	    || isupper(*str2)	   // more caps (must match) in the reference
	    || isdigit(*str2)){	   // numbers (must match) in the reference
    reset(start);	// back up (don't consume)
    _ok = false;	// reject
  }else{	    // reached natural end, accept
    skipcom();
    _ok = true;
  }}
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::pscan(const std::string& s)
{
  int start = cursor();
  for (;;){
    int tokenstart = cursor();
    {if (pmatch(s)){	// found it
      _ok = true;
      reset(tokenstart);
      break;
    }else if (!more()){	// ran out
      _ok = false;
      reset(start);
      break;
    }else{		// skip and try again
      skiparg();
    }}
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
