%  -*- mode: SLang; mode: fold -*-
% Sample Kinsoku Library 
% 	1998 Kazuhisa Yoshino (k-yosino@inatori.netsweb.ne.jp)
%
% Tail char
variable kinsoku_str_td = "A C B D F G H I j l n p r t z v x X [ \           @ B D F H b       J K R S T U ]    ) ] }";
% Head char
variable kinsoku_str_hd = "i k m o q s y u w         ( [ {";


% Jgs̐擪ɋւꂽ(kinsoku_str_td Ɏw肵)ꍇ
% Os̍sɂ̕ړ
% 
% return ֑ 
define jp_kinsoku_oikomi ()
{
   variable n = 1, ret = 0;
   variable ch;
   variable buf = Null_String;
   push_spot();
   
   bol();
   while (n)
     {
	bol_skip_white ();
	ch = jwhat_char ();
	buf = Null_String;
	if (ch / 0x100) buf = strcat(buf, char (ch / 0x100));
	buf = strcat(buf, char (ch & 0xff));
	if (is_list_element(kinsoku_str_td, buf, ' '))
	  {
	     push_spot ();
	     bol ();
	     if(left (1))
	       {
%		  if (ch / 0x100) insert_char (ch / 0x100);
%		  insert_char (ch & 0xff);
		  insert(buf);
		  pop_spot ();
		  del();
		  ret++;
	       }
	     else pop_spot ();
	  }
	else n = 0;
     }
   pop_spot ();
   return ret;
}

% Jgs̍sɋւꂽ(kinsoku_str_hd Ɏw肵)ꍇ
% s̐擪ɂ̕ړ
% 
% return ֑ 
define jp_kinsoku_oidasi ()
{
   variable n = 1, ret = 0;
   variable ch;
   variable buf = Null_String;
   
   push_spot();
   
   eol();
   while (n and not(bolp()))
     {
	go_left_1 ();
	ch = jwhat_char ();
	buf = Null_String;
	if (ch / 0x100) buf = strcat(buf, char (ch / 0x100));
	buf = strcat(buf, char (ch & 0xff));
	
	if (is_list_element(kinsoku_str_hd, buf, ' '))
	  {
	     push_spot ();
	     
	     eol ();
	     if(right (1))
	       {
		  bol_skip_white ();
		  if (ch / 0x100) insert_char (ch / 0x100);
		  insert_char (ch & 0xff);
		  pop_spot ();
		  del();
		  ret++;
	       }
	     else pop_spot ();
	  }
	else n = 0;
     }
   pop_spot ();
   
   return ret;
}


define jp_kinsoku()
{
   push_spot();
   
   jp_kinsoku_oikomi ();
%   call("previous_line_cmd");
   bol ();
   if (left (1))
     jp_kinsoku_oidasi ();
   
   pop_spot();
}

define text_mode_hook ()
{
   set_buffer_hook("wrap_hook", "jp_kinsoku");
}


