/* vi:set ts=8 sts=0 sw=8:
 * $Id: about.c,v 1.13 2000/02/19 06:54:43 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "main.h"
#include "about.h"
#ifdef USE_GNOME
#include <gnome.h>
#else
#include "dialog.h"
#endif


#define APP_COPYRIGHT		"Copyright (C) 1998-2000"
#define APP_AUTHOR_NAME		"Andy C. Kahn"


/*** global function definitions ***/
/*
 * PUBLIC: about_cb
 *
 * menu callback to create and show the about box
 */
void
about_cb(GtkWidget *wgt, gpointer cbdata)
{
#ifdef USE_GNOME
	const char *authors[] = { APP_AUTHOR_NAME,
				  NULL };
	char *copyright;
	copyright = g_new(char, strlen(APP_AUTHOR_NAME) + 32);
	sprintf(copyright, "(C) 1998-2000 by %s", APP_AUTHOR_NAME);
	gtk_widget_show(gnome_about_new(
				(const char *)APP_NAME,
				(const char *)APP_VERSION,
				(const char *)copyright,
				(const char **)authors,
				(const char *)APP_URL,
				(const char *)NULL));
	g_free(copyright);
#else
	char *title, *msg;
	int len;

	title = g_new(char, strlen(APP_NAME) + 9);
	g_snprintf(title, strlen(APP_NAME) + 9, " About %s ", APP_NAME);

	len = strlen(APP_NAME) + strlen(APP_VERSION) + strlen(APP_URL) +
	      strlen(APP_COPYRIGHT) + strlen(APP_AUTHOR_NAME) + 32;
	msg = g_new(char, len);
	g_snprintf(msg, len,
		" %s %s \n"	/* APP_NAME, APP_VERSION */
		" %s \n"	/* APP_URL */
		"\n"
		" %s \n"	/* APP_COPYRIGHT */
		" %s ",		/* APP_AUTHOR_NAME */
		APP_NAME, APP_VERSION,
		APP_URL,
		APP_COPYRIGHT,
		APP_AUTHOR_NAME
	);

	(void)do_dialog_ok(title, msg);
	g_free(msg);
	g_free(title);
#endif
} /* about_cb */


/* the end */
