/* vertchar.c - draws text vertically
   Copyright (C) 1998 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#include <config.h>
#include <X11/Xlib.h>
#include "mad.h"

static unsigned int vertical_chars[96][8] =

{
    {0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000000},

    {0000000,
     0040000,
     0020000,
     0020000,
     0040000,
     0100000,
     0100000,
     0040000},

    {0000000,
     0000000,
     0000000,
     0000400,
     0001200,
     0076176,
     0100001,
     0100001},

    {0000000,
     0000000,
     0000000,
     0000000,
     0177777,
     0000000,
     0000000,
     0000000},

    {0000000,
     0100001,
     0100001,
     0076176,
     0001200,
     0000400,
     0000000,
     0000000},

    {0000000,
     0002034,
     0003004,
     0002604,
     0002144,
     0002024,
     0003014,
     0000004},

    {0002000,
     0003400,
     0002300,
     0000060,
     0000114,
     0002602,
     0003001,
     0002006},

    {0000000,
     0002004,
     0003014,
     0002664,
     0000100,
     0002664,
     0003014,
     0002004},

    {0000000,
     0003740,
     0000034,
     0000140,
     0003600,
     0000140,
     0000034,
     0003740},

    {0000000,
     0003400,
     0002340,
     0000030,
     0000004,
     0000030,
     0002340,
     0003400},

    {0000004,
     0003770,
     0002010,
     0000004,
     0000004,
     0000004,
     0003770,
     0002000},

    {0000000,
     0000030,
     0002004,
     0002004,
     0002004,
     0037770,
     0002000,
     0002000},

    {0000000,
     0003470,
     0001104,
     0002104,
     0002104,
     0002104,
     0001610,
     0000034},

    {0000000,
     0001400,
     0002004,
     0002004,
     0001004,
     0003774,
     0002004,
     0002004},

    {0000000,
     0002001,
     0003777,
     0002011,
     0002011,
     0002010,
     0001020,
     0000740},

    {0000000,
     0000740,
     0001020,
     0002010,
     0002011,
     0002011,
     0003777,
     0002001},

    {0000000,
     0000760,
     0001010,
     0002004,
     0002004,
     0002004,
     0001010,
     0000760},

    {0000004,
     0001774,
     0002004,
     0002000,
     0002000,
     0001004,
     0003774,
     0002004},

    {0000004,
     0001774,
     0002000,
     0002004,
     0001774,
     0002000,
     0002004,
     0001774},

    {0000004,
     0000004,
     0000004,
     0077774,
     0040004,
     0040004,
     0040004,
     0000004},

    {0000004,
     0002034,
     0001140,
     0000600,
     0000200,
     0000104,
     0077774,
     0040004},

    {0000000,
     0143774,
     0142002,
     0002001,
     0002001,
     0002001,
     0000002,
     0000014},

    {0000004,
     0000004,
     0000004,
     0143774,
     0142004,
     0002004,
     0002004,
     0000004},

    {0000004,
     0001774,
     0002004,
     0002000,
     0002000,
     0001004,
     0077774,
     0040004},

    {0002000,
     0002006,
     0001611,
     0002121,
     0002121,
     0002121,
     0001661,
     0000016},

    {0020000,
     0042000,
     0042004,
     0042004,
     0037774,
     0002004,
     0002004,
     0002000},

    {0000000,
     0000630,
     0001204,
     0002204,
     0002204,
     0002204,
     0001210,
     0000760},

    {0000000,
     0040004,
     0077774,
     0002004,
     0002004,
     0002004,
     0001010,
     0000760},

    {0000000,
     0003430,
     0001004,
     0002004,
     0002004,
     0002004,
     0001010,
     0000760},

    {0000000,
     0000760,
     0001010,
     0002004,
     0002004,
     0002004,
     0077774,
     0040000},

    {0000004,
     0001774,
     0002210,
     0002204,
     0002204,
     0002204,
     0001104,
     0000070},

    {0000000,
     0000000,
     0000000,
     0000000,
     0144000,
     0170000,
     0000000,
     0000000},

    {0000000,
     0000001,
     0000001,
     0000001,
     0000001,
     0000001,
     0000001,
     0000001},

    {0000000,
     0010000,
     0020000,
     0040000,
     0100000,
     0040000,
     0020000,
     0010000},

    {0000000,
     0000000,
     0000000,
     0000000,
     0177777,
     0100001,
     0100001,
     0100001},

    {0000000,
     0000006,
     0000030,
     0000140,
     0000600,
     0003000,
     0014000,
     0060000},

    {0000000,
     0100001,
     0100001,
     0100001,
     0177777,
     0000000,
     0000000,
     0000000},

    {0000000,
     0040074,
     0060004,
     0054004,
     0043404,
     0040304,
     0040064,
     0070014},

    {0000000,
     0060000,
     0056004,
     0001404,
     0000374,
     0001404,
     0056004,
     0060000},

    {0000000,
     0040014,
     0070064,
     0046700,
     0001000,
     0046700,
     0070064,
     0040014},

    {0000000,
     0077740,
     0040034,
     0000340,
     0003400,
     0000340,
     0040034,
     0077740},

    {0000000,
     0076000,
     0041700,
     0000060,
     0000014,
     0000060,
     0041700,
     0076000},

    {0040000,
     0077770,
     0040004,
     0000004,
     0000004,
     0040004,
     0077770,
     0040000},

    {0000000,
     0070000,
     0040004,
     0040004,
     0077774,
     0040004,
     0040004,
     0070000},

    {0000000,
     0000160,
     0070210,
     0020404,
     0040404,
     0041004,
     0021010,
     0016174},

    {0000004,
     0016014,
     0021160,
     0040600,
     0040400,
     0040404,
     0077774,
     0040004},

    {0000000,
     0007741,
     0030031,
     0040046,
     0040044,
     0040044,
     0030030,
     0007740},

    {0000000,
     0017000,
     0020400,
     0040200,
     0040204,
     0040204,
     0077774,
     0040004},

    {0000000,
     0017760,
     0020010,
     0040004,
     0040004,
     0040004,
     0020010,
     0017760},

    {0040000,
     0077774,
     0040010,
     0000160,
     0001600,
     0016000,
     0020004,
     0077774},

    {0000000,
     0077774,
     0020004,
     0016000,
     0001600,
     0016000,
     0020004,
     0077774},

    {0000000,
     0000074,
     0000004,
     0000004,
     0040004,
     0040004,
     0077774,
     0040004},

    {0000004,
     0040014,
     0070060,
     0006300,
     0001400,
     0041004,
     0077774,
     0040004},

    {0040000,
     0077760,
     0040010,
     0040004,
     0040004,
     0000004,
     0000010,
     0000160},

    {0000000,
     0040004,
     0040004,
     0040004,
     0077774,
     0040004,
     0040004,
     0040004},

    {0040004,
     0077774,
     0041004,
     0001000,
     0001000,
     0041004,
     0077774,
     0040004},

    {0000400,
     0070774,
     0020410,
     0040404,
     0040004,
     0020010,
     0014030,
     0003740},

    {0000000,
     0070000,
     0040000,
     0043700,
     0040404,
     0040404,
     0077774,
     0040004},

    {0000000,
     0070074,
     0040004,
     0043704,
     0040404,
     0040404,
     0077774,
     0040004},

    {0000000,
     0007740,
     0030030,
     0040004,
     0040004,
     0040004,
     0077774,
     0040004},

    {0000000,
     0070070,
     0020004,
     0040004,
     0040004,
     0040004,
     0030030,
     0007740},

    {0000000,
     0016170,
     0021204,
     0040404,
     0040404,
     0040404,
     0077774,
     0040004},

    {0000000,
     0000074,
     0003704,
     0034100,
     0040100,
     0034100,
     0003704,
     0000074},

    {0000000,
     0037750,
     0042104,
     0044044,
     0044044,
     0043704,
     0020010,
     0017760},

    {0000000,
     0016000,
     0021400,
     0040202,
     0040147,
     0040002,
     0024000,
     0014000},

    {0000000,
     0000000,
     0000000,
     0000600,
     0003140,
     0014030,
     0060006,
     0100001},

    {0000000,
     0002100,
     0002100,
     0002100,
     0002100,
     0002100,
     0002100,
     0002100},

    {0000000,
     0100001,
     0060006,
     0014030,
     0003140,
     0000600,
     0000000,
     0000000},

    {0000000,
     0000000,
     0000000,
     0003034,
     0003037,
     0003031,
     0000000,
     0000000},

    {0000000,
     0000000,
     0000000,
     0003014,
     0003014,
     0003014,
     0000000,
     0000000},

    {0000000,
     0017760,
     0020410,
     0040204,
     0040204,
     0040204,
     0020410,
     0017020},

    {0000000,
     0016160,
     0021210,
     0040404,
     0040404,
     0040404,
     0021210,
     0016160},

    {0000000,
     0070000,
     0047000,
     0040740,
     0040036,
     0040000,
     0040000,
     0070000},

    {0000000,
     0030360,
     0050410,
     0041004,
     0041004,
     0041004,
     0030410,
     0007760},

    {0000000,
     0000760,
     0041010,
     0042004,
     0042004,
     0042004,
     0041050,
     0077460},

    {0000000,
     0000100,
     0000104,
     0077774,
     0020104,
     0014104,
     0003100,
     0000700},

    {0000000,
     0016160,
     0021210,
     0040404,
     0040404,
     0040404,
     0020010,
     0014060},

    {0000000,
     0016034,
     0021004,
     0040604,
     0040104,
     0024064,
     0014014,
     0000000},

    {0000000,
     0000000,
     0000004,
     0000004,
     0077774,
     0020004,
     0020004,
     0000000},

    {0000000,
     0007760,
     0030014,
     0040002,
     0040002,
     0030014,
     0007760,
     0000000},

    {0000000,
     0140000,
     0030000,
     0007000,
     0000700,
     0000060,
     0000014,
     0000003},

    {0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000014,
     0000036,
     0000014},

    {0000000,
     0000400,
     0000400,
     0000400,
     0000400,
     0000400,
     0000400,
     0000400},

    {0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000036,
     0000031,
     0000031},

    {0000000,
     0000400,
     0000400,
     0000400,
     0017760,
     0000400,
     0000400,
     0000400},

    {0000000,
     0003300,
     0001200,
     0004440,
     0017760,
     0004440,
     0001200,
     0003300},

    {0000000,
     0000000,
     0000000,
     0000000,
     0007760,
     0030014,
     0040002,
     0100001},

    {0000000,
     0100001,
     0040002,
     0030014,
     0007760,
     0000000,
     0000000,
     0000000},

    {0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0170000,
     0144000,
     0144000},

    {0000000,
     0000404,
     0000750,
     0034430,
     0042344,
     0041404,
     0036304,
     0000070},

    {0000000,
     0140074,
     0034102,
     0003102,
     0036674,
     0041140,
     0041034,
     0036003},

    {0000000,
     0014160,
     0024210,
     0040404,
     0177777,
     0040404,
     0021044,
     0016070},

    {0004000,
     0074040,
     0007740,
     0004076,
     0074040,
     0007740,
     0004076,
     0000040},

    {0000000,
     0000000,
     0170000,
     0144000,
     0000000,
     0170000,
     0144000,
     0000000},

    {0000000,
     0000000,
     0000000,
     0077002,
     0077747,
     0077002,
     0000000,
     0000000},

    {0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000000,
     0000000}};


void XDrawVericalString8x16 (Display * display, Drawable d, GC gc,
			 int x, int y, char *string, int length)
{
    int i;
    for (i = 0; i < length; i++) {
	XPoint points[128];
	int npoints = 0;
	int c, row, col;
	c = string[i];
	if (c < ' ' || c > '~')
	    c = 0;
	else
	    c = 127 - string[i];
	for (row = 0; row < 8; row++) {
	    int mask = 1 << 15;
	    for (col = 0; col < 16; col++) {
		if (vertical_chars[c][row] & mask) {
		    points[npoints].x = col + x;
		    points[npoints++].y = row + y + ((length - 1) - i) * 8;
		}
		mask >>= 1;
	    }
	}
	XDrawPoints (display, d, gc, points, npoints, CoordModeOrigin);
    }
}




