/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : z1lpf.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitZ1LowPassFilter
|
| Description : DSPKitZ1LowPassFilter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_Z1LOWPASSFILTER_H_
#define _DSPKIT_Z1LOWPASSFILTER_H_

#include "processo.h"

class DSPKitZ1LowPassFilter : public DSPKitProcessor
{
  public:

    DSPKitZ1LowPassFilter ();
    long setInput (DSPKitProcessor *ip);
    void setG (double newG);
    long getSample (double &outputSample);
    double getG () const;

  protected:

    double buf;
    double g;
};

inline void DSPKitZ1LowPassFilter::setG (double newG)
{
  g = newG;
}

inline double DSPKitZ1LowPassFilter::getG () const
{
  return g;
}

#endif

/***************************************************************************/
