/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : sumavg.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitSumAvg
|
| Description : DSPKitSumAvg
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char sumavg_cc [] = "$Id$";

#include "sumavg.h"

long DSPKitSumAvg::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  inputList [0] = input;
  inputCount = 1;
  return 0;
}

long DSPKitSumAvg::addInput (DSPKitProcessor *ip)
{
  ip->setOutput(this);
  if (inputCount >= SUMAVGMAXINPUTS) return -1;
  inputList [inputCount++] = ip;
  return 0;
}

long DSPKitSumAvg::getSample (double &outputSample)
{
  long   i;
  long   ok;
  long   success;
  double inputSample;

  outputSample = 0.0;
  success      = 0;

  for (i=0,ok=0; i<inputCount; i++)
  {
    if (inputList [i]->getSample (inputSample))
    {
      outputSample += inputSample;
      success++;
      ok = 1;
    }
  }
  
  if (ok) outputSample = outputSample / success;
  return ok;
}

/***************************************************************************/
