/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : sum.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitSum
|
| Description : DSPKitSum
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char sum_cc [] = "$Id$";

#include "sum.h"

long DSPKitSum::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  inputList [0] = input;
  inputCount = 1;
  return 0;
}

long DSPKitSum::addInput (DSPKitProcessor *ip)
{
  ip->setOutput(this);
  if (inputCount >= SUMMAXINPUTS) return -1;
  inputList [inputCount++] = ip;
  return 0;
}

long DSPKitSum::getSample (double &outputSample)
{
  long   i;
  long   ok;
  double inputSample;

  outputSample = 0.0;

  for (i=0,ok=0; i<inputCount; i++)
  {
    if (inputList [i]->getSample (inputSample))
    {
      outputSample += inputSample;
      ok = 1;
    }
  }

  return ok;
}

/***************************************************************************/
