/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : processo.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitProcessor
|
| Description : DSPKitProcessor
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_PROCESSOR_H_
#define _DSPKIT_PROCESSOR_H_

#include <iostream.h>
#include <time.h>
#include <math.h>

class DSPKitProcessor
{
  public:

    DSPKitProcessor();
    virtual ~DSPKitProcessor ();
    virtual long setInput (DSPKitProcessor *ip);
    virtual void setOutput (DSPKitProcessor *op);
    virtual DSPKitProcessor *getInput () const;
    DSPKitProcessor *getOutput () const;
    virtual double getSamplingRate () const;
    virtual long getSample (double &outputSample);

  protected:

    DSPKitProcessor *input;
    DSPKitProcessor *output;
    double inputSamplingRate;
};

inline DSPKitProcessor::~DSPKitProcessor ()
{
}

inline void DSPKitProcessor::setOutput (DSPKitProcessor *op)
{
  output = op;
}

inline DSPKitProcessor *DSPKitProcessor::getInput () const
{
  return input;
}

inline DSPKitProcessor *DSPKitProcessor::getOutput () const
{
  return output;
}

inline double DSPKitProcessor::getSamplingRate () const
{
  return inputSamplingRate;
}

inline long DSPKitProcessor::getSample (double &outputSample)
{
  return input->getSample (outputSample);
}

#endif

/***************************************************************************/
