/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : mult.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitMult
|
| Description : DSPKitMult
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char mult_cc [] = "$Id$";

#include "mult.h"

long DSPKitMult::setInput (DSPKitProcessor *ip)
{
  multInput = 0;
  return DSPKitProcessor::setInput (ip);
}

void DSPKitMult::setMultInput (DSPKitProcessor *mip)
{
  multInput = mip;
  multInput->setOutput (this);
}

long DSPKitMult::getSample (double &outputSample)
{
  double multSample;

  outputSample = 0.0;
  if (input->getSample (outputSample) == 0) return 0;
  if (!multInput || multInput->getSample (multSample) == 0) return 0;
  outputSample *= multSample;
  return 1;
}

/***************************************************************************/
