/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dpwriter.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDPWriter
|
| Description : DSPKitDPWriter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char dpwriter_cc [] = "$Id$";

#include "dpwriter.h"
#ifndef NOFORMS
#include "DPTich_main.h"
#endif

#define DSPXCHECK         2000
#define MINREMAININCREASE 5
// #define SNEAKYCHECK

DSPKitDPWriter::DSPKitDPWriter ()
{
  sample    = 0;
  inputR    = 0;
  input3    = 0;
  input4    = 0;
  channel_a = 0;
  channel_b = 1;
  channel_c = 2;
  channel_d = 3;
}

void DSPKitDPWriter::setChannels (
  long newChannel_a,
  long newChannel_b)
{
  channel_a = newChannel_a;
  channel_b = newChannel_b;
}

void DSPKitDPWriter::setChannels (
  long newChannel_a,
  long newChannel_b,
  long newChannel_c,
  long newChannel_d)
{
  channel_a = newChannel_a;
  channel_b = newChannel_b;
  channel_c = newChannel_c;
  channel_d = newChannel_d;
}
    
long DSPKitDPWriter::setInputOutput (
  DSPKitProcessor *ipL,
  DSPKitProcessor *ipR,
  DPSample *newSample)
{
  setInputOutput (ipL,ipR,0,0,newSample);
  return 0;
}

long DSPKitDPWriter::setInputOutput (
  DSPKitProcessor *ipL,
  DSPKitProcessor *ipR,
  DSPKitProcessor *ip3,
  DSPKitProcessor *ip4,
  DPSample *newSample)
{
  if (DSPKitProcessor::setInput (ipL)) return -1;
  inputR = ipR;
  if (inputR) inputR->setOutput(this);
  input3 = ip3;
  if (input3) input3->setOutput(this);
  input4 = ip4;
  if (input4) input4->setOutput(this);

  sample           = newSample;
  samplesWritten   = 0;
  i                = 0;
  frames           = sample->getFrames ();
  checkReset       = DSPXCHECK;
  check            = 1;
  return 0;
}

void DSPKitDPWriter::run ()
{
  long   outputFrames;
  double outputRate;
  long   outputSeconds;
  long   inputFrames;
  long   inputFrameCount;
  long   elapsedSeconds;
  long   remainSeconds;
  long   lastRemainSeconds;
  double percentComp;
  long   waitShown;

  double inputSampleL;
  double inputSampleR;
  double inputSample3;
  double inputSample4;
  long   inputRetValL;
  long   inputRetValR;
  long   inputRetVal3;
  long   inputRetVal4;
  char   tempString [50];
  
  extraListEntry *e;
  
  inputRetValL = 0;
  inputRetValR = 0;
  inputRetVal3 = 0;
  inputRetVal4 = 0;
  waitShown    = 0;
  
  #ifdef SNEAKYCHECK
  XEvent newEvent;
  #endif
  
  remainSeconds = 0;
  
  do
  {
    if (input)  inputRetValL = input->getSample(inputSampleL);
    if (inputR) inputRetValR = inputR->getSample(inputSampleR);
    if (input3) inputRetVal3 = input3->getSample(inputSample3);
    if (input4) inputRetVal4 = input4->getSample(inputSample4);
    
    if ((inputRetValL || inputRetValR ||
    inputRetVal3 || inputRetVal4) && i == frames)
    {
      if (e = sample->expand (1.0))
      {
        frames = e->end + 1;
      }
    }
    
    if ((inputRetValL || inputRetValR || 
    inputRetVal3 || inputRetVal4) && i >= 0 && i < frames)
    {
      if (inputRetValL)
        sample->setFrameDbExtra (i,channel_a,(double) inputSampleL);
      
      if (inputRetValR)
        sample->setFrameDbExtra (i,channel_b,(double) inputSampleR);
        
      if (inputRetVal3)
        sample->setFrameDbExtra (i,channel_c,(double) inputSample3);
        
      if (inputRetVal4)
        sample->setFrameDbExtra (i,channel_d,(double) inputSample4);
        
      i++;
      samplesWritten++;
    }
    
    if (!--check)
    {
      check = checkReset;
      lastRemainSeconds = remainSeconds;
      outputFrames      = samplesWritten;
      outputRate        = inputSamplingRate;
      outputSeconds     = (long) (outputFrames / outputRate);
      inputFrameCount   = DSPReader_L->getSampleCount ();
      inputFrames       = inputFrameCount - DSPReader_L->getSamplesLeft ();
      elapsedSeconds    = time (NULL) - DSPTime;
      percentComp       = 100.0 * ((double) inputFrames) / inputFrameCount;

      if (percentComp > 0.0)
        remainSeconds =
        (long)(((100.0 - percentComp) / percentComp) * elapsedSeconds);
      else
        remainSeconds = 0;
      
      if (remainSeconds > lastRemainSeconds)
      {
        if ((remainSeconds - lastRemainSeconds) < MINREMAININCREASE)
          remainSeconds = lastRemainSeconds;
      }

      #ifndef NOFORMS
      if (percentComp >= 99.99999999 && !waitShown)
      {
        fl_show_object (executeForm->wait);
        waitShown = 1;
      }
      
      sprintf (tempString,"%ld",outputFrames);
      fl_set_object_label (executeForm->frames,tempString);
      sprintf (tempString,"%02ld:%02d:%02d",
        (outputSeconds / 3600),
        (outputSeconds / 60) % 60,
        (outputSeconds % 60));
      fl_set_object_label (executeForm->time,tempString);
      sprintf (tempString,"%02ld:%02d:%02d",
        (elapsedSeconds / 3600),
        (elapsedSeconds / 60) % 60,
        (elapsedSeconds % 60));
      fl_set_object_label (executeForm->elapsedTime,tempString);
      sprintf (tempString,"%02ld:%02d:%02d",
        (remainSeconds / 3600),
        (remainSeconds / 60) % 60,
        (remainSeconds % 60));
      fl_set_object_label (executeForm->remainTime,tempString);
      sprintf (tempString,"%.0lf",percentComp);
      fl_set_object_label (executeForm->percentComp,tempString);
      fl_set_slider_value (executeForm->percentCompSlider,percentComp);
      
      #ifdef SNEAKYCHECK
      if (XCheckWindowEvent (fl_display,
        executeForm->executeForm->window,~(long)0,&newEvent))
      {
        XPutBackEvent (fl_display,&newEvent);
        fl_check_forms ();
      }
      #else
      fl_check_forms ();
      #endif // SNEAKYCHECK
      #endif // NOFORMS
    }
  }
  while ((inputRetValL || inputRetValR ||
  inputRetVal3 || inputRetVal4) && i <= frames && !DSPCancel && !DSPStop);
  
  #ifndef NOFORMS
  if (waitShown) fl_hide_object (executeForm->wait);
  #endif
}

/***************************************************************************/
