/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dist.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDistortion
|
| Description : DSPKitDistortion
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char dist_cc [] = "$Id$";

#include "dist.h"

// 16 bit arrays ranging from -32768 to +32767 - first value is length

long valve [] =
{
#include "valve.h"
};

long tube [] =
{
#include "tube.h"
};

long DSPKitDistortion::setType (long newType)
{
  i    = 1;
  type = newType;
  return 1;
}

long DSPKitDistortion::getSampleCount ()
{
  switch (type)
  {
    case 0 :
      return valve [0];
    
    case 1 :
      return tube [0];
    
    default :
      return 0;
  }
}

long DSPKitDistortion::getSample (double &outputSample)
{
  // type 0 = valve
  // type 1 = tube
  
  switch (type)
  {
    case 0 :
      outputSample = valve [i++] / 32768.0;
      if (i > valve [0]) i = 1;
      break;
    
    case 1 :
      outputSample = tube [i++] / 32768.0;
      if (i > tube [0]) i = 1;
      break;
    
    default :
      return 0;
  }
  return 1;
}

/***************************************************************************/
