/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : amp.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitAmp
|
| Description : DSPKitAmp
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_AMP_H_
#define _DSPKIT_AMP_H_

#include "processo.h"

class DSPKitAmp : public DSPKitProcessor
{
  public:

    DSPKitAmp ();
    void setGain (double g);
    long getSample (double &outputSample);
    double getGain () const;

  protected:

    double gain;
};

inline DSPKitAmp::DSPKitAmp ()
{
  gain = 1.0;
}

inline void DSPKitAmp::setGain (double g)
{
  gain = g;
}

inline double DSPKitAmp::getGain () const
{
  return gain;
}

#endif

/***************************************************************************/
