/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_linux_macros.cc
|
| Revision    : 1.0
| Date        : 26/03/97
|
| Object      : None
|
| Description : Macro routines for linux replacement code
|
| (c) Richard Kent 1997
|
| $Id$
|
****************************************************************************/

static char DPTich_linux_macros_cc [] = "$Id$";

#ifdef LINUX

#include "DPTich_linux_macros.h"

/*---------------------------------------------------------------------------
| FUNCTION ulRead
---------------------------------------------------------------------------*/
int ulRead (int file,unsigned long *ul)
{
  if (read (file,ul,4) != 4) return 0;
  #ifdef BIGENDIAN
  *ul = swapbytes (*ul);
  #endif
  return 4;
}

/*---------------------------------------------------------------------------
| FUNCTION lRead
---------------------------------------------------------------------------*/
int lRead (int file,long *l)
{
  if (read (file,l,4) != 4) return 0;
  #ifdef BIGENDIAN
  *l = swapbytes (*l);
  #endif
  return 4;
}

/*---------------------------------------------------------------------------
| FUNCTION usRead
---------------------------------------------------------------------------*/
int usRead (int file,unsigned short *us)
{
  if (read (file,us,2) != 2) return 0;
  #ifdef BIGENDIAN
  *us = swapbytes (*us);
  #endif
  return 2;
}

/*---------------------------------------------------------------------------
| FUNCTION sRead
---------------------------------------------------------------------------*/
int sRead (int file,short *s)
{
  if (read (file,s,2) != 2) return 0;
  #ifdef BIGENDIAN
  *s = swapbytes (*s);
  #endif
  return 2;
}

/*---------------------------------------------------------------------------
| FUNCTION ucRead
---------------------------------------------------------------------------*/
int ucRead (int file,unsigned char *uc)
{
  if (read (file,uc,1) != 1) return 0;
  return 1;
}

/*---------------------------------------------------------------------------
| FUNCTION cRead
---------------------------------------------------------------------------*/
int cRead (int file,signed char *c)
{
  if (read (file,c,1) != 1) return 0;
  return 1;
}

/*---------------------------------------------------------------------------
| FUNCTION eRead
---------------------------------------------------------------------------*/
int eRead (int file,double *d)
{
  unsigned char etemp [10];
  if (read (file,etemp,10) != 10) return 0;
  *d = convertFromIeeeExtended (etemp);
  return 10;
}

/*---------------------------------------------------------------------------
| FUNCTION idRead
---------------------------------------------------------------------------*/
int idRead (int file,char *c)
{
  if (read (file,c,4) != 4) return 0;
  return 4;
}

/*---------------------------------------------------------------------------
| FUNCTION pstringRead
---------------------------------------------------------------------------*/
int pstringRead (int file,char **c)
{
  unsigned char stringsize;
  unsigned char temp;
  int count;
  *c = 0;  
  if (!ucRead (file,&stringsize)) return 0;
  *c = (char *) calloc (stringsize + 1,sizeof (char));
  if (!(*c)) return 0;
  if (stringsize > 0)
    if (read (file,*c,stringsize) != stringsize) return 0;
  (*c) [stringsize] = 0;
  count = 1 + stringsize;
  if (!(stringsize % 2))
  {
    if (!ucRead (file,&temp)) return 0;
    count++;
  }
  return count;
}

/*---------------------------------------------------------------------------
| FUNCTION ulWrite
---------------------------------------------------------------------------*/
int ulWrite (int file,unsigned long ul)
{
  #ifdef BIGENDIAN
  ul = swapbytes (ul);
  #endif
  if (write (file,&ul,4) != 4) return 0;
  return 4;
}

/*---------------------------------------------------------------------------
| FUNCTION lWrite
---------------------------------------------------------------------------*/
int lWrite (int file,long l)
{
  #ifdef BIGENDIAN
  l = swapbytes (l);
  #endif
  if (write (file,&l,4) != 4) return 0;
  return 4;
}

/*---------------------------------------------------------------------------
| FUNCTION usWrite
---------------------------------------------------------------------------*/
int usWrite (int file,unsigned short us)
{
  #ifdef BIGENDIAN
  us = swapbytes (us);
  #endif
  if (write (file,&us,2) != 2) return 0;
  return 2;
}

/*---------------------------------------------------------------------------
| FUNCTION sWrite
---------------------------------------------------------------------------*/
int sWrite (int file,short s)
{
  #ifdef BIGENDIAN
  s = swapbytes (s);
  #endif
  if (write (file,&s,2) != 2) return 0;
  return 2;
}

/*---------------------------------------------------------------------------
| FUNCTION ucWrite
---------------------------------------------------------------------------*/
int ucWrite (int file,unsigned char uc)
{
  if (write (file,&uc,1) != 1) return 0;
  return 1;
}

/*---------------------------------------------------------------------------
| FUNCTION cWrite
---------------------------------------------------------------------------*/
int cWrite (int file,signed char c)
{
  if (write (file,&c,1) != 1) return 0;
  return 1;
}

/*---------------------------------------------------------------------------
| FUNCTION eWrite
---------------------------------------------------------------------------*/
int eWrite (int file,double d)
{
  unsigned char etemp [10];
  convertToIeeeExtended (d,etemp);
  if (write (file,etemp,10) != 10) return 0;
  return 10;
}

/*---------------------------------------------------------------------------
| FUNCTION idWrite
---------------------------------------------------------------------------*/
int idWrite (int file,char *c)
{
  if (write (file,c,4) != 4) return 0;
  return 4;
}

/*---------------------------------------------------------------------------
| FUNCTION pstringWrite
---------------------------------------------------------------------------*/
int pstringWrite (int file,char *c)
{
  unsigned char stringsize;
  unsigned char temp;
  int count;
  
  if (c) stringsize = strlen (c);
  else stringsize = 0;
  if (!ucWrite (file,stringsize)) return 0;
  if (stringsize)
    if (write (file,c,stringsize) != stringsize) return 0;
  count = 1 + stringsize;
  if (!(stringsize % 2))
  {
    temp = 0;
    if (!(ucWrite (file,temp))) return 0;
    count++;
  }
  return count;
}

/*---------------------------------------------------------------------------
| FUNCTION swapbytes
---------------------------------------------------------------------------*/
void swapbytes (char *buffer,int n)
{
  int i;
  int j;
  char temp;
  
  if (n < 1) return;
  i = 0;
  j = n - 1;
  while (i < j)
  {
    temp = buffer [i];
    buffer [i] = buffer [j];
    buffer [j] = temp;
    i++;
    j--;
  }
}

unsigned long swapbytes (unsigned long ul)
{
  unsigned long ulNew = ul;
  swapbytes (((char *) &ulNew),sizeof (ulNew));
  return ulNew;
}

long swapbytes (long l)
{
  long lNew = l;
  swapbytes (((char *) &lNew),sizeof (lNew));
  return lNew;
}

unsigned short swapbytes (unsigned short us)
{
  unsigned short usNew = us;
  swapbytes (((char *) &usNew),sizeof (usNew));
  return usNew;
}

short swapbytes (short s)
{
  short sNew = s;
  swapbytes (((char *) &sNew),sizeof (sNew));
  return sNew;
}

unsigned int swapbytes (unsigned int ui)
{
  unsigned int uiNew = ui;
  swapbytes (((char *) &uiNew),sizeof (uiNew));
  return uiNew;
}

int swapbytes (int i)
{
  int iNew = i;
  swapbytes (((char *) &iNew),sizeof (iNew));
  return iNew;
}

double swapbytes (double d)
{
  double dNew = d;
  swapbytes (((char *) &dNew),sizeof (dNew));
  return dNew;
}

#endif // linux

/***************************************************************************/
