/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: stoi.c,v 1.2 1999/11/08 06:20:21 bbarrett Exp $
 *
 *	Function:	- convert decimal or hexadecimal string to integer
 */

#include "lam.h"

int4
stoi(s)

unsigned char		*s;

{
	int4  		base;			/* base of digits */
	int4  		i;			/* result */
	int4  		sign;			/* sign of result */
	int		valid;			/* valid digit? */
	unsigned char	c;			/* current digit */

	if (s[0] == '-') {
		sign = -1;
		s++;
	} else {
		sign = 1;
	}

	if ((s[0] == '0') && ((s[1] == 'x') || (s[1] == 'X'))) {
		base = 16;
		s += 2;
	} else {
		base = 10;
	}

	i = 0;
	valid = 1;

	while (*s && valid) {
		c = *s;

		if ((c >= '0') && (c <= '9')) {
			i = (i * base) + (c - '0');
		}

		else if (base == 16) {

			if ((c >= 'a') && (c <= 'f')) {
				i = (i * base) + (c - 'a' + 0xa);
			}

			else if ((c >= 'A') && (c <= 'F')) {
				i = (i * base) + (c - 'A' + 0xA);
			}

			else {
				valid = 0;
			}
		} else {
			valid = 0;
		}

		s++;
	}

	i *= sign;

	return(i);
}
