(**
  A simple group with one child. The group just puts a
  little bit, defineable space around the object. Usefull,
  if you want an object enbedded with a little space and
  with background color set.
**)

MODULE VOPlate;

(*
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VODisplay,
       G := VOGUIObject;

TYPE
  Plate*     = POINTER TO PlateDesc;
  PlateDesc* = RECORD (G.GroupDesc)
                 horizSpace,
                 vertSpace   : LONGINT;
                 spaceHValue,
                 spaceHType,
                 spaceVValue,
                 spaceVType  : LONGINT;
               END;

  PROCEDURE (p : Plate) Init*;

  BEGIN
    p.Init^;

    p.spaceHType:=G.sizeFontPRel;
    p.spaceHValue:=25;
    p.spaceVType:=G.sizeFontPRel;
    p.spaceVValue:=25;
  END Init;

  (**
    Add the object to present.

    NOTE
    Plate only support one object. Repeatetly calling
    add will overwrite this object with the new one.
  **)

  PROCEDURE (p : Plate) Add*(object : G.Object);

  BEGIN
    p.list:=object;
  END Add;

  (**
    Set the space beween the frame and its contens in percent. Default to
    Display.spaceWidth and Display.spaceHeight.
  **)

  PROCEDURE (p : Plate) SetSpace*(horizValue, horizType, vertValue, vertType : LONGINT);

  BEGIN
    p.spaceHValue:=horizValue;
    p.spaceHType:=horizType;
    p.spaceVValue:=vertValue;
    p.spaceVType:=vertType;
  END SetSpace;

  PROCEDURE (p : Plate) CalcSize*(display : D.Display);

  BEGIN
    p.horizSpace:=2*p.GetSize(p.spaceHValue,p.spaceHType,0,display.scrWidth,display.spaceWidth,TRUE,display);
    p.vertSpace:=2*p.GetSize(p.spaceVValue,p.spaceVType,0,display.scrHeight,display.spaceHeight,FALSE,display);

    p.width:=p.horizSpace;
    p.height:=p.vertSpace;

    p.minWidth:=p.width;
    p.minHeight:=p.height;

    IF p.list#NIL THEN
      p.list.CalcSize(display);
      INC(p.width,p.list.oWidth);
      INC(p.height,p.list.oHeight);
      INC(p.minWidth,p.list.oMinWidth);
      INC(p.minHeight,p.list.oMinHeight);
    END;

    p.CalcSize^(display);
  END CalcSize;

  PROCEDURE (p : Plate) Draw*(x,y : LONGINT; draw : D.DrawInfo);

  BEGIN
    p.Draw^(x,y,draw);

    p.DrawBackground(p.x,p.y,p.width,p.height);

    IF p.list#NIL THEN
      p.list.Resize(p.width-p.horizSpace,p.height-p.vertSpace);
      p.list.Draw(p.x+(p.width-p.list.oWidth) DIV 2,
                  p.y+(p.height-p.list.oHeight) DIV 2,draw);
    END;
  END Draw;


  PROCEDURE (p : Plate) Refresh*(x,y,w,h : LONGINT);

  BEGIN
    IF p.visible & p.Intersect(x,y,w,h) THEN
      IF p.list#NIL THEN
        p.list.Refresh(x,y,w,h);
      END;
    END;
  END Refresh;


  PROCEDURE (p : Plate) Hide*;

  BEGIN
    IF p.visible THEN
      IF p.list#NIL THEN
        p.list.Hide;
      END;
      p.DrawHide;
      p.Hide^;
    END;
  END Hide;

END VOPlate.