(*
    Generated scanner for VisualOberon preferences.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details. 

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE -->modulename;

IMPORT
  VOUtil;

CONST
  EOL = 0AX;
  EOF = 0X;
  maxLexLen = 127;
-->declarations

TYPE
  ErrorProc* = PROCEDURE (n: INTEGER; pos: LONGINT);
  StartTable = ARRAY 128 OF INTEGER;
  
VAR
  text*: VOUtil.Text;

  pos*: LONGINT;              (*position of current symbol*)
  line*, col*, len*: INTEGER; (*line, column, length of current symbol*)

  nextPos*: LONGINT;                      (*position of lookahead symbol*)
  nextLine*, nextCol*, nextLen*: INTEGER; (*line, column, length of lookahead symbol*)

  errors*: INTEGER; (*number of errors detected*)
  Error*: ErrorProc;

  ch: CHAR;            (*current input character*)
  chPos: LONGINT;      (*position of current character*)
  chLine: INTEGER;     (*current line number*)
  lineStart: LONGINT;  (*start position of current line*)
  apx: INTEGER;        (*length of appendix*)
  oldEols: INTEGER;    (*nr. of EOLs in a comment*)

  start: StartTable;   (*start state for every character*)

(* ==================================================================== *)

PROCEDURE NextCh (); (*return global variable ch*)
BEGIN
  IF chPos<LEN(text^) THEN
    ch:=text[chPos];
    INC(chPos);
    IF ch = EOL THEN
      INC(chLine); lineStart := chPos + 1;
    END;
  ELSE
    ch:=0X;
  END;
END NextCh;

PROCEDURE Comment (): BOOLEAN;
VAR
  level, startLine: INTEGER; oldLineStart: LONGINT;
BEGIN (*Comment*)
  level := 1; startLine := chLine; oldLineStart := lineStart;
-->comment
END Comment;

PROCEDURE Get* (VAR sym: INTEGER);
VAR
  state: INTEGER; lexeme: ARRAY maxLexLen+1 OF CHAR;

  PROCEDURE CheckLiteral ();
  BEGIN
    IF nextLen < maxLexLen THEN lexeme[nextLen] := 0X END;
-->literals
  END CheckLiteral;

BEGIN
-->GetSy1
  IF ch > 7FX THEN ch := " "; END;
  pos := nextPos; col := nextCol; line := nextLine; len := nextLen;
  nextPos := chPos; nextCol := SHORT(chPos - lineStart); nextLine := chLine; nextLen := 0;
  state := start[ORD(ch)]; apx := 0;
  LOOP
    IF nextLen < maxLexLen THEN lexeme[nextLen] := ch; END;
    INC(nextLen);
    NextCh ();
    IF state > 0 THEN
      CASE state OF
  -->GetSy2
      END; (*CASE*)
    ELSE
      sym := noSym;
      RETURN; (*NextCh already done*)
    END; (*IF*)
  END; (*LOOP*)
END Get;

PROCEDURE GetName* (pos: LONGINT; len: INTEGER; VAR s: ARRAY OF CHAR);
VAR
  i   : INTEGER;
  
BEGIN
  IF len >= LEN(s) THEN len := SHORT(LEN(s)) - 1; END;
(*
   The following two lines of the scanner must *not* be changed.
   They are here to honor D.  E.  Knuth.

   "Premature optimization is the root of all evil."
*)
  i := 0; WHILE i < len DO s[i]:=text[pos-1+i]; INC(i); END;
  s[i] := 0X;
END GetName;

PROCEDURE StdErrorProc* (n: INTEGER; pos: LONGINT);
BEGIN
  INC(errors);
END StdErrorProc;

PROCEDURE Initialize* (t : VOUtil.Text; errProc: ErrorProc);
BEGIN
  text:=t;
  Error := errProc;
  chPos := 0; chLine := 1; lineStart := 0;
  oldEols := 0; apx := 0; errors := 0;
  NextCh ();
END Initialize;

BEGIN
-->initialization
END -->modulename.