
;;; TODO
;;;      -m"foo the bar" as well as -m "foo the bar"
;;;      --bob=sally as well sa --bob sally
;;; if that's consistent with getopt(3), that is

(define-class <opt-spec> (<object>)
  ;; map strings or characters to option specs
  ;; an option spec is (option-name . arg-spec)
  ;; an arg-spec is () => no arguments
  ;;             or (1) => required argument
  ;;             or (?) => optional argument
  (options type: <list>))

(define-class <arg-list> (<object>)
  arguments
  queued-options
  options
  non-options)

(define-method getopt ((self <list>) (spec <opt-spec>))
  (getopt (make <arg-list>
	    arguments: self
	    queued-options: '()
	    options: '()
	    non-options: '())
	  spec))

(define-method getopt ((self <arg-list>) (spec <opt-spec>))
  (let ((a (arguments self)))
    (cond
     ((pair? (queued-options self))
      (process-option (car (queued-options self))
		      spec
		      a
		      (cdr (queued-options self))
		      (options self)
		      (non-options self)))
     ((null? a)
      (values #f self))
     ((and (> (string-length (car a)) 1)
	   (char=? (string-ref (car a) 0) #\-)
	   (not (char=? (string-ref (car a) 1) #\-)))
      (getopt (make <arg-list>
		arguments: (cdr a)
		queued-options: (cdr (string->list (car a)))
		options: (options self)
		non-options: (non-options self))
	      spec))
     ((and (> (string-length (car a)) 2)
	   (char=? (string-ref (car a) 0) #\-)
	   (char=? (string-ref (car a) 1) #\-))
      (process-option (substring (car a) 2)
		      spec
		      (cdr a)
		      '()
		      (options self)
		      (non-options self)))
     (else
      (process-non-option (car a)
			  spec
			  (cdr a)
			  (options self)
			  (non-options self))))))

(define (process-non-option non-option
			    spec
			    rest-of-args
			    current-options
			    current-non-options)
  (getopt (make <arg-list>
	    arguments: rest-of-args
	    queued-options: '()
	    options: current-options
	    non-options: (cons non-option current-non-options))
	  spec))

(define (process-option given-option
			spec
			rest-of-args
			rest-queued
			current-options
			current-non-options)
  (let ((x (assoc given-option (options spec))))
    (if x
	(let ((opt-name (cadr x)))
	  (cond
	   ((equal? (cddr x) '())
	    (values opt-name
		    (make <arg-list>
		      arguments: rest-of-args
		      queued-options: rest-queued
		      options: (cons (list opt-name) current-options)
		      non-options: current-non-options)))
	   ((equal? (cddr x) '(1))
	    (values opt-name
		    (make <arg-list>
		      arguments: (cdr rest-of-args)
		      queued-options: rest-queued
		      options: (cons (list opt-name (car rest-of-args))
				     current-options)
		      non-options: current-non-options)
		    (car rest-of-args)))
	 ((equal? (cddr x) '(?))
	  (error "ni: ~s" x))
	 (else
	  (error "huh: ~s" x))))
	(error "unknown option: ~s" given-option))))

#|
(define *tspec*
  (make <opt-spec>
    options: '((#\v verbose)
	       (#\f file 1)
	       (#\z compress)
	       (#\R recursive)
	       ("preserve" preserve))))

(define (test . args)
  (let loop ((i (map to-string args)))
    (bind ((opt i #rest args (getopt i *tspec*)))
      (if opt
	  (begin
	    (format #t "~s => ~s\n" opt args)
	    (loop i))
	  (print i)))))
|#
