/* Header for module math, generated by p2c */
#ifndef MATH_H
#define MATH_H



#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif



#ifdef MATH_G
# define vextern
#else
# define vextern extern
#endif



typedef struct ma_complex {
    double re, im;
} ma_complex;



#define ma_maxreal      1.797073134862315e308
#define ma_eps          1.110765125711e-16
#define ma_maxreal_     ma_maxreal
#define ma_minreal      (-ma_maxreal)
#define ma_pi           3.1415926535897932384
#define ma_2pi          6.2831853071795864768
#define ma_hpi          1.5707963267948966192
#define ma_ln10         2.3025850929940456840
#define ma_iln10        0.4342944819032518277
#define ma_dr           0.0174532925199433
#define ma_rd           57.2957795130823

vextern Const ma_complex ma_c0;
vextern Const ma_complex ma_c1;
vextern Const ma_complex ma_cm1;
vextern Const ma_complex ma_cI;
vextern Const ma_complex ma_cmI;
vextern Const ma_complex ma_cpi;

#define ma_fmt_vprec    1
#define ma_fmt_usej     2
#define ma_fmt_usespace 4
#define ma_fmt_useparen 8



vextern long ma_dummy;



/* obsolete -- use initrandom/seedrandom */
extern boolean ma_trapuf PP((int flag));
extern double ma_rround PP((double r));
extern double ma_rrounde PP((double r));
extern double ma_rtrunc PP((double r));
extern double ma_rfloor PP((double r));
extern double ma_rceil PP((double r));
extern double ma_rfrac PP((double r));
extern boolean ma_isint PP((double r));
extern boolean ma_isinteger PP((double r));
extern boolean ma_rnequal PP((double a, double b, double eps));
extern long ma_igcd PP((long a, long b));
extern double ma_rmod PP((double a, double b));
extern double ma_rmod2 PP((double a, double b, long *q));
extern double ma_rrem PP((double a, double b));
extern double rrem_ieee PP((double a, double b));
extern long ma_sgn PP((double r));
extern double ma_sgn2 PP((double r, double s));
extern double ma_min2 PP((double a, double b));
extern double ma_min3 PP((double a, double b, double c));
extern double ma_min4 PP((double a, double b, double c, double d));
extern double ma_max2 PP((double a, double b));
extern double ma_max3 PP((double a, double b, double c));
extern double ma_max4 PP((double a, double b, double c, double d));
extern double ma_mean2 PP((double a, double b));
extern double ma_mean3 PP((double a, double b, double c));
extern double ma_mean4 PP((double a, double b, double c, double d));
extern Void ma_rswap2 PP((double *a, double *b));
extern Void ma_rsort2 PP((double *a, double *b));
extern Void ma_rsort3 PP((double *a, double *b, double *c));
extern Void ma_rsort4 PP((double *a, double *b, double *c, double *d));
extern double ma_rbound PP((double min, double r, double max));
extern boolean ma_between PP((double min, double r, double max));
extern boolean ma_betweenm PP((double min, double r, double max,
			       double margin));
extern Void ma_amin PP((double *min, double r));
extern Void ma_amax PP((double *max, double r));
extern Void ma_aminmax PP((double *min, double *max, double r));
extern double ma_rsucc PP((double r));
extern double ma_rpred PP((double r));
extern Char *ma_strfmtreal PP((Char *ma_Result, double r, long wid, long prec));
extern Char *ma_strfmtreal2 PP((Char *ma_Result, double r, long wid,
				long prec, long flags, double min,
				double max));
extern double ma_log PP((double r));
extern double ma_tentox PP((double x));
extern double ma_mtentox PP((double x));
extern double ma_ytoi PP((double y, long i));
extern double ma_yrooti PP((double y, long i));
extern double ma_ytox PP((double y, double x));
extern double ma_mytox PP((double y, double x));
extern double ma_hypot PP((double a, double b));
extern Void ma_quadrsolve PP((double a, double b, double c, double *x1,
			      double *x2));
extern Void ma_sincos PP((double r, double *s, double *c));
extern double ma_tan PP((double r));
extern double ma_arcsin PP((double r));
extern double ma_arccos PP((double r));
extern double ma_arctan2 PP((double r1, double r2));

/* = arctan(r1/r2) */
extern Void ma_sincosd PP((double r, double *s, double *c));
extern double ma_sind PP((double r));
extern double ma_cosd PP((double r));
extern double ma_tand PP((double r));
extern double ma_arcsind PP((double r));
extern double ma_arccosd PP((double r));
extern double ma_arctand PP((double r));
extern double ma_arctand2 PP((double r1, double r2));
extern double ma_sinh PP((double r));
extern double ma_cosh PP((double r));
extern double ma_tanh PP((double r));
extern double ma_arcsinh PP((double r));
extern double ma_arccosh PP((double r));
extern double ma_arctanh PP((double r));
extern double ma_lngamma PP((double x, boolean *minus));
extern double ma_rgamma PP((double x));
extern long ma_ifactorial PP((long n));
extern double ma_lnfactorial PP((long n));
extern long ma_ibincoef PP((long a, long b));

/*a >= b*/
extern double ma_rbincoef PP((long a, long b));
extern ma_complex ma_cmake PP((double r, double i));
extern ma_complex ma_creal PP((double r));
extern ma_complex ma_cimag PP((double i));
extern ma_complex ma_cadd PP((ma_complex a, ma_complex b));
extern ma_complex ma_csub PP((ma_complex a, ma_complex b));
extern ma_complex ma_cmul PP((ma_complex a, ma_complex b));
extern ma_complex ma_cdiv PP((ma_complex a, ma_complex b));
extern ma_complex ma_csqr PP((ma_complex a));
extern ma_complex ma_csqrt PP((ma_complex a));
extern boolean ma_cequal PP((ma_complex a, ma_complex b));
extern boolean ma_cnequal PP((ma_complex a, ma_complex b, double epssq));
extern ma_complex ma_csmul PP((double r, ma_complex a));
extern ma_complex ma_cconj PP((ma_complex a));
extern ma_complex ma_cneg PP((ma_complex a));
extern double ma_cangle PP((ma_complex a));
extern double ma_cabs PP((ma_complex a));
extern double ma_cabssqr PP((ma_complex a));
extern double ma_cdiff PP((ma_complex a, ma_complex b));
extern ma_complex ma_cexp PP((ma_complex a));
extern ma_complex ma_cexpi PP((ma_complex a));
extern ma_complex ma_cln PP((ma_complex a));
extern ma_complex ma_csin PP((ma_complex a));
extern ma_complex ma_ccos PP((ma_complex a));
extern ma_complex ma_ctan PP((ma_complex a));
extern ma_complex ma_carcsin PP((ma_complex a));
extern ma_complex ma_carccos PP((ma_complex a));
extern ma_complex ma_carctan PP((ma_complex a));
extern ma_complex ma_csinh PP((ma_complex a));
extern ma_complex ma_ccosh PP((ma_complex a));
extern ma_complex ma_ctanh PP((ma_complex a));
extern ma_complex ma_carcsinh PP((ma_complex a));
extern ma_complex ma_carccosh PP((ma_complex a));
extern ma_complex ma_carctanh PP((ma_complex a));
extern Char *ma_strcomplex PP((Char *ma_Result, ma_complex a));
extern Char *ma_strfmtcomplex PP((Char *ma_Result, ma_complex a, long wid,
				  long prec));
extern Char *ma_strfmtcomplex2 PP((Char *ma_Result, ma_complex a, long wid,
				   long prec, long flags, double min,
				   double max));
extern Void ma_strsubreadcomplex PP((Char *buf, long first, long *pos,
				     ma_complex *a));
extern ma_complex ma_strreadcomplex PP((Char *buf));
extern double ma_rrand PV();
extern long ma_rand2 PP((long min, long max));
extern double ma_rrand2 PP((double min, double max));
extern double ma_nrand2 PP((double mean, double sdev));
extern Void ma_initrandom PP((Anyptr *s));
extern Void ma_seedrandom PP((Anyptr *s, long seed));
extern double ma_urandom PP((Anyptr s));
extern long ma_irandom PP((Anyptr s, long min, long max));
extern double ma_rrandom PP((Anyptr s, double min, double max));
extern double ma_nrandom PP((Anyptr s, double mean, double sdev));



#undef vextern

#endif /*MATH_H*/

/* End. */

