;
; SYNON.SCM - define the standard synonyms for ULTRA II
;
; Source Version: 4.0
; Software Release #92-0043
;
; #include <pact-copyright.h>
;

(synonym powr pow)
(synonym powrx powx)
(synonym log10x logx)
(synonym derivative der)
(synonym integrate int)

(if (defined? ultra)
    (begin
      (synonym erase era)
      (synonym domain dom)
      (synonym range ran)
      (synonym kill expunge)
      (synonym select # cur pl)
      (synonym compose comp)
      (synonym smooth3 smooth)
      (synonym hardcopy hc)
      (synonym show unhide)

      (synonym + sum)
      (synonym - dif)
      (synonym * prod)
      (synonym / quot ratio div)
      (synonym load ld*)

; Any time after 2/93, promote rd*, and save* to C and eliminate open, and wrt.
      (synonym open rd*)
      (synonym wrt save*)

      (synonym end quit)
      (synonym break stop)))

(if (defined? pdbview)
    (begin
      (synonym array-nd-set nds)
      (synonym change-dimension chdim)
      (synonym close clf)
      (synonym close-textfile clt)
      (synonym close-viewport clv)
      (synonym close-window clw)
      (synonym change-file cf)
      (synonym change-palette palette)
      (synonym change-viewport cv)
      (synonym change-window cw)
      (synonym copy-mapping cm)
      (synonym data-reference dref)
      (synonym default-viewport-rendering vr)
      (synonym define-file-variable defv)
      (synonym define-file-variable* defv*)
      (synonym delete-mapping dl)
      (synonym display-domain pld)
      (synonym display-mapping pl)
      (synonym drawable-rendering dr)
      (synonym domv fix-domain)
      (synonym ranm fix-range)
      (synonym hardcopy-viewport hcv)
      (synonym hardcopy-window hc)
      (synonym list-files lf)
      (synonym list-mappings-in-viewport lsv)
      (synonym list-windows lw)
      (synonym make-ac-mapping-direct ac)
      (synonym make-lr-mapping-direct lr)
      (synonym make-lr-mapping-synth lrs)
      (synonym make-cp-set cps)
      (synonym print-mapping pm)
      (synonym save-mapping sm)
      (synonym update-window wu)
      (synonym view-angle va)
      (synonym open-textfile ot)
      (synonym close-textfile ct)
      (synonym table tab)))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

; LETREC - temporarily reassign letrec to let* to ease the transition from
;        - the original incorrect definition of letrec

(define-macro (letrec . args)
   (printf nil "\nUse let* instead of letrec. It is the correct function.\n")
   (printf nil "In the future letrec will be defined to its standard meaning.\n\n")
   (set! letrec let*)
   (apply let* args))

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
