/*
 * SXHOOK.C - write hook for SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_HASH_HOOK - write hook for pdblib to handle hash tables
 *               - pdb_wr_hook
 */

memdes *_SX_hash_hook(file, vr, dp)
   PDBfile *file;
   char *vr;
   defstr *dp;
   {char c, *type;
    char new_mem[MAXLINE];

    type = dp->type;

    if (strcmp(type, "object") == 0)
       {c = SC_arrtype(vr, 0);
        switch (c)
           {case SC_INTEGER_I :
	         strcpy(new_mem, "long *val");
		 break;

            case SC_FLOAT_I :
	         strcpy(new_mem, "double *val");
		 break;

            case SC_STRING_I :
	         strcpy(new_mem, "string *val");
		 break;

            case CONS :
	         strcpy(new_mem, "cons *val");
		 break;

            case VARIABLE :
	         strcpy(new_mem, "variable *val");
		 break;

            case BOOLEAN :
            case EOF_OBJ :
            case NULL_OBJ :
	         strcpy(new_mem, "boolean *val");
		 break;

            case VECTOR :
	         strcpy(new_mem, "vector *val");
		 break;

            default :
	         strcpy(new_mem, "unknown val");};

        _SX_ins_mem(dp, new_mem, 1, file);};

    return(dp->members);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_INS_MEM - replace member number "imem" with "member".
 *             - imem is 0 based.
 */

void _SX_ins_mem(dp, member, imem, file)
   defstr *dp;
   char *member;
   int imem;
   PDBfile *file;
   {memdes *lst, *prev, *desc;
    int i;

    for (prev = NULL, lst = dp->members,  i = 0;
         lst != NULL;
         lst = lst->next, i++)
        {if (i == imem)
            {desc = _PD_mk_descriptor(member, file->default_offset);
	     desc->member_offs = lst->member_offs;
             if (prev == NULL)
                dp->members = desc;
             else
                prev->next = desc;

             desc->next = lst->next;
             _PD_rl_descriptor(lst);

             return;};

         prev = lst;};

    SS_error("HASK_HOOK FAILED - _SX_INS_MEM", SS_null);
    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_INIT_HASH_OBJECT - initialize pdb_write_hook for scheme hash objects
 *                      - add scheme types into a hash table.
 */

void _SX_init_hash_objects(file)
   PDBfile *file;
   {defstr *dp;

/* hash table types */
    PD_def_attr_str(file);

    dp = PD_defstr(file, "object",
                   "char *print_name", 
                   "char *val", 
                   "char eval_type", 
                   "function print", 
                   "function release", 
                   LAST);
    if (dp == NULL)
       SS_error("COULDN'T DEFINE OBJECT TO FILE - _SX_INIT_HASH_OBJECTS",
                SS_null);

/* PML types */
    PD_def_mapping(file);

/* SCHEME object types */
    PD_defstr(file, "string",
              "integer length",
              "char *string",
              LAST);

    PD_defstr(file, "cons",
              "object *car", 
              "object *cdr", 
              LAST);

    PD_defstr(file, "variable",
              "char *name", 
              "object *value", 
              LAST);

    PD_defstr(file, "boolean",
              "char *name", 
              "integer value", 
              LAST);

    PD_defstr(file, "vector",
              "integer length", 
              "object **vect", 
              LAST);

/* PDBLib types */
    PD_defstr(file, "dimdes",
              "long index_min", 
              "long index_max", 
              "long number", 
              "dimdes *next", 
              LAST);

    PD_defstr(file, "memdes",
              "char *member", 
#ifdef _LARGE_FILES
              "long_long member_offs",
#else
              "long member_offs", 
#endif
              "char *cast_memb", 
              "long cast_offs", 
              "char *type", 
              "char *base_type", 
              "char *name", 
              "dimdes *dimensions", 
              "long number", 
              "memdes *next", 
              LAST);

    PD_defstr(file, "symblock",
              "long number", 
#ifdef _LARGE_FILES
              "long_long diskaddr",
#else
              "long diskaddr",
#endif
              LAST);

    PD_defstr(file, "symindir",
#ifdef _LARGE_FILES
	      "long_long addr",
#else
              "long addr",
#endif
	      "long n_ind_type",
	      "long arr_offs",
              LAST);

    PD_defstr(file, "syment",
              "char *type", 
              "dimdes *dimensions", 
              "long number", 
              "symindir indirects", 
              "symblock *blocks",
              LAST);

    PD_defstr(file, "defstr",
              "char *type", 
              "long size_bits", 
              "long size", 
              "integer alignment", 
              "integer n_indirects",
              "integer convert",
              "integer onescmp",
              "integer unsgned",
              "integer order_flag",
              "integer *order",
              "long *format",
              "memdes *member", 
              LAST);    

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_FPRINTF - variable arg version of fPRINTf for the library
 *            - combines both PG_fprintf and SS_printf
 *            - the one for graphical printing options and the other
 *            - for transcript logging
 */

#ifdef PCC

int SX_fprintf(fp, fmt, va_alist)
   FILE *fp;
   char *fmt;
   va_dcl

#endif

#ifdef ANSI

int SX_fprintf(FILE *fp, char *fmt, ...)

#endif

   {FILE *hp;
    int ret;
    extern char Sbuffer[];
    extern int SC_DECLARE(_PG_display_page,
		       (PG_device *dev, FILE *fp, char *s));

    if (fp != NULL)
       {SC_VA_START(fmt);
	SC_VSPRINTF(Sbuffer, fmt);
	SC_VA_END;

	hp = SS_OUTSTREAM(SS_histdev);
	if (SS_hist_flag && (fp != hp))
	   io_printf(hp, "%s", Sbuffer);

/* the ifs are nested to get the right behavior wrt the print_flag
 * LEAVE THEM ALONE !!!!
 */
	if ((PG_console_device != NULL) && ((fp == stdout) || (fp == stdscr)))
	   ret = (PG_console_device->gprint_flag) ?
	         _PG_display_page(PG_console_device, fp, Sbuffer) :
		 FALSE;
	else
	   ret = io_puts(Sbuffer, fp);};

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

