/*
 * SHSTRG.C - string functions for the LARGE Scheme system
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRCMP - Scheme version of strcmp */

object *SS_strcmp(argl, func)
   object *argl;
   int (*func)();
   {object *o1, *o2;
    char *s1, *s2;

    if (!SS_stringp(o1 = SS_car(argl)))
       SS_error("FIRST ARG NOT STRING - STRING-COMPARE", o1);
    if (!SS_stringp(o2 = SS_cadr(argl)))
       SS_error("SECOND ARG NOT STRING - STRING-COMPARE", o2);

    s1 = SS_STRING_TEXT(o1);
    s2 = SS_STRING_TEXT(o2);

    return(func(s1, s2) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/

/*                          C LEVEL STRING ROUTINES                         */

/*--------------------------------------------------------------------------*/

/* _SS_STREQ - string=? at C level */

int _SS_streq(s1, s2)
   char *s1, *s2;
   {return(strcmp(s1, s2) == 0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_STRGE - string>=? at C level */

int _SS_strge(s1, s2)
   char *s1, *s2;
   {return(strcmp(s1, s2) >= 0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_STRGT - string>? at C level */

int _SS_strgt(s1, s2)
   char *s1, *s2;
   {return(strcmp(s1, s2) > 0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_STRLE - string<=? at C level */

int _SS_strle(s1, s2)
   char *s1, *s2;
   {return(strcmp(s1, s2) <= 0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_STRLT - string<? at C level */

int _SS_strlt(s1, s2)
   char *s1, *s2;
   {return(strcmp(s1, s2) < 0);}

/*--------------------------------------------------------------------------*/

/*                      SCHEME LEVEL STRING ROUTINES                        */

/*--------------------------------------------------------------------------*/

/* SS_STREQ - string=? in Scheme */

object *SS_streq(argl)
   object *argl;
   {return(SS_strcmp(argl, _SS_streq));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRGE - string>=? in Scheme */

object *SS_strge(argl)
   object *argl;
   {return(SS_strcmp(argl, _SS_strge));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRGT - string>? in Scheme */

object *SS_strgt(argl)
   object *argl;
   {return(SS_strcmp(argl, _SS_strgt));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRLE - string<=? in Scheme */

object *SS_strle(argl)
   object *argl;
   {return(SS_strcmp(argl, _SS_strle));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRLT - string<? in Scheme */

object *SS_strlt(argl)
   object *argl;
   {return(SS_strcmp(argl, _SS_strlt));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRLEN - string-length in Scheme */

object *SS_strlen(str)
   object *str;
   {if (!SS_stringp(str))
       SS_error("ARGUMENT NOT STRING - STRING-LENGTH", str);

/* when tokenizing strings this definition makes more sense */
    return(SS_mk_integer((BIGINT) strlen(SS_STRING_TEXT(str))));}

/* this was the original and served well for many years */ 
/*   return(SS_mk_integer((BIGINT) SS_STRING_LENGTH(str)));} */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRREF - string-ref in Scheme */

object *SS_strref(argl)
   object *argl;
   {char *s;
    object *str, *num;
    int n;

    if (!SS_stringp(str = SS_car(argl)))
       SS_error("BAD STRING - STRING-REF", str);

    if (!SS_integerp(num = SS_cadr(argl)))
       SS_error("BAD INDEX - STRING-REF", num);

    s = SS_STRING_TEXT(str);
    n = (int) SS_INTEGER_VALUE(num);
    if (n > SS_STRING_LENGTH(str))
       SS_error("INDEX PAST END OF STRING - STRING-REF", num);

    return(SS_mk_char((int) s[n]));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRSUB - substring in Scheme */

object *SS_strsub(argl)
   object *argl;
   {object *str, *o1, *o2;
    int n, n1, n2;
    char *s, c;

    if (!SS_stringp(str = SS_car(argl)))
       SS_error("BAD STRING - SUBSTRING", str);

    if (!SS_integerp(o1 = SS_cadr(argl)))
       SS_error("BAD STARTING INDEX - SUBSTRING", o1);

    if (!SS_integerp(o2 = SS_caddr(argl)))
       SS_error("BAD ENDING INDEX - SUBSTRING", o2);

    s = SS_STRING_TEXT(str);
    n = SS_STRING_LENGTH(str);
    n1 = (int) SS_INTEGER_VALUE(o1);
    n2 = (int) SS_INTEGER_VALUE(o2);
    if ((n1 > n) || (n1 < 0))
       n1 = 0;
/*       SS_error("STARTING INDEX PAST END OF STRING - STRING-REF", o1); */
    if ((n2 > n) || (n2 < 0))
       n2 = n;
/*       SS_error("ENDING INDEX PAST END OF STRING - STRING-REF", o2); */

    c = s[n2];
    s[n2] = '\0';
    str = SS_mk_string(&s[n1]);
    s[n2] = c;

    return(str);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRAPP - string-append for Scheme */

object *SS_strapp(argl)
   object *argl;
   {object *ths;
    int n;
    char *s, *t;

    t = FMAKE(char, "SS_STRAPP:t");
    *t = '\0';
    for (n = 1; SS_consp(argl); argl = SS_cdr(argl))
        {ths = SS_car(argl);
         if (SS_stringp(ths))
            {n += SS_STRING_LENGTH(ths);
             s  = FMAKE_N(char, n, "SS_STRAPP:s");
             strcpy(s, t);
             strcat(s, SS_STRING_TEXT(ths));
             SFREE(t);
             t = s;};};

    ths = SS_mk_string(t);
    SFREE(t);

    return(ths);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRLST - string->list in Scheme */

object *SS_strlst(str)
   object *str;
   {char *s;
    object *ret;
    int i, n;

    if (!SS_stringp(str))
       SS_error("ARGUMENT NOT STRING - STRING->LIST", str);

    s = SS_STRING_TEXT(str);
    n = SS_STRING_LENGTH(str);
    for (ret = SS_null, i = 0; i < n; i++)
        ret = SS_mk_cons(SS_mk_char(s[i]), ret);

    return(SS_reverse(ret));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LSTSTR - list->string for Scheme */

object *SS_lststr(argl)
   object *argl;
   {char *s;
    int i, n;
    object *str, *ths;

    argl = SS_car(argl);
    if (!SS_consp(argl))
       SS_error("ARGUMENT MUST BE LIST - LIST->STRING", argl);

    n = _SS_length(argl);
    s = FMAKE_N(char, n+1, "SS_LSTSTR:s");
    for (i = 0; SS_consp(argl); argl = SS_cdr(argl))
        {ths = SS_car(argl);
         if (SS_charobjp(ths))
            s[i++] = (char) SS_CHARACTER_VALUE(ths);};
    s[i] = '\0';

    str = SS_mk_string(s);
    SFREE(s);

    return(str);}

/*--------------------------------------------------------------------------*/

/*                           CHARACTER ROUTINES                             */

/*--------------------------------------------------------------------------*/

/* SS_CHREQ - char=? for Scheme */

object *SS_chreq(argl)
   object *argl;
   {object *o1, *o2;

    if (!SS_charobjp(o1 = SS_car(argl)) || !SS_charobjp(o2 = SS_cadr(argl)))
       SS_error("ARGUMENTS NOT CHARACTERS - CHAR=?", argl);

    return((SS_CHARACTER_VALUE(o1) == SS_CHARACTER_VALUE(o2)) ?
           SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CHRGE - char>=? for Scheme */

object *SS_chrge(argl)
   object *argl;
   {object *o1, *o2;

    if (!SS_charobjp(o1 = SS_car(argl)) || !SS_charobjp(o2 = SS_cadr(argl)))
       SS_error("ARGUMENTS NOT CHARACTERS - CHAR>=?", argl);

    return((SS_CHARACTER_VALUE(o1) >= SS_CHARACTER_VALUE(o2)) ?
           SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CHRGT - char>? for Scheme */

object *SS_chrgt(argl)
   object *argl;
   {object *o1, *o2;

    if (!SS_charobjp(o1 = SS_car(argl)) || !SS_charobjp(o2 = SS_cadr(argl)))
       SS_error("ARGUMENTS NOT CHARACTERS - CHAR>?", argl);

    return((SS_CHARACTER_VALUE(o1) > SS_CHARACTER_VALUE(o2)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CHRLE - char<=? for Scheme */

object *SS_chrle(argl)
   object *argl;
   {object *o1, *o2;

    if (!SS_charobjp(o1 = SS_car(argl)) || !SS_charobjp(o2 = SS_cadr(argl)))
       SS_error("ARGUMENTS NOT CHARACTERS - CHAR<=?", argl);

    return((SS_CHARACTER_VALUE(o1) <= SS_CHARACTER_VALUE(o2)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CHRLT - char<? for Scheme */

object *SS_chrlt(argl)
   object *argl;
   {object *o1, *o2;

    if (!SS_charobjp(o1 = SS_car(argl)) || !SS_charobjp(o2 = SS_cadr(argl)))
       SS_error("ARGUMENTS NOT CHARACTERS - CHAR<?", argl);

    return((SS_CHARACTER_VALUE(o1) < SS_CHARACTER_VALUE(o2)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CHRINT - char->integer for Scheme */

object *SS_chrint(chr)
   object *chr;
   {if (!SS_charobjp(chr))
       SS_error("ARGUMENT NOT CHARACTER - CHAR->INTEGER", chr);

    return(SS_mk_integer((BIGINT) SS_CHARACTER_VALUE(chr)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INTCHR - integer->char for Scheme */

object *SS_intchr(obj)
   object *obj;
   {if (!SS_integerp(obj))
       SS_error("ARGUMENT NOT INTEGER - INTEGER->CHAR", obj);

    return(SS_mk_char((int) SS_INTEGER_VALUE(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_SYMSTR - symbol->string for Scheme */

object *SS_symstr(arg)
   object *arg;
   {if (!SS_variablep(arg))
       SS_error("ARGUMENT NOT VARIABLE - SYMBOL->STRING", arg);

    return(SS_mk_string(SS_VARIABLE_NAME(arg)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRSYM - string->symbol for Scheme */

object *SS_strsym(str)
   object *str;
   {if (!SS_stringp(str))
       SS_error("ARGUMENT NOT STRING - STRING->SYMBOL", str);

    return(SS_mk_variable(SS_STRING_TEXT(str), SS_null));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_UPCASE - up-case for Scheme */

object *SS_upcase(str)
   object *str;
   {char *s;

    if (SS_stringp(str))
       s = SS_STRING_TEXT(str);

    else if (SS_variablep(str))
       s = SS_VARIABLE_NAME(str);

    else
       SS_error("BAD ARGUMENT - SS_UPCASE", str);

    return(SS_mk_string(SC_str_upper(s)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_DNCASE - dn-case for Scheme */

object *SS_dncase(str)
   object *str;
   {char *s;

    if (SS_stringp(str))
       s = SS_STRING_TEXT(str);

    else if (SS_variablep(str))
       s = SS_VARIABLE_NAME(str);

    else
       SS_error("BAD ARGUMENT - SS_DNCASE", str);

    return(SS_mk_string(SC_str_lower(s)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

