/*
 * SHPRM1.C - Scheme Primitives
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

static int nest_level = 0;
    
#define SS_Unquoted(x) ((x) == SS_unqproc)
#define Unqsplicing(x) ((x) == SS_unqspproc)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_NEWSYM - make-new-symbol, generate a new uninterned symbol */

object *SS_newsym(obj)
   object *obj;
   {static int numb = 0;
    char *token, name[MAXLINE];
   
    if (SS_stringp(obj))
       token = SS_STRING_TEXT(obj);
    else if (SS_variablep(obj))
       token = SS_VARIABLE_NAME(obj);
    else
       SS_error("BAD OBJECT - SS_NEWSYM", obj);

    sprintf(name, "%s%-d", token, numb++);

    return(SS_mk_variable(name, SS_null));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_QUOTE - quote macro in Scheme */

object *SS_quote(obj)
   object *obj;
   {

    return(obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_UNQUOTE - does the real work of the unquote macro */

object *SS_Unquote(x)
   object *x;
   {

    x = SS_exp_eval(SS_cadr(x));

    return(x);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_SPLICE - given  a return budding return list, an object, and the
 *           - rest of the original list
 *           - bash it all together and return the finished return list
 */

object *SS_Splice(ncns, item, lst, tcns)
   object *ncns, *item, *lst, *tcns;
   {object *rest;

/* process the rest of the list */
    rest = _SS_quasiq(lst, nest_level);

/* check the cases */
    if (SS_nullobjp(ncns))
       ncns = SS_mk_cons(item, rest);

    else
/* if there are no remaining elements */
       {if (SS_nullobjp(rest))
           ncns = _SS_append(ncns, item);

/* if the remainder is not a list */
        else if (!SS_consp(rest))

/* if the item is null */
           {if (SS_nullobjp(item))
               _SS_setcdr(tcns, rest);

/* if the item is non-null */
            else
               ncns = _SS_append(ncns, SS_mk_cons(item, rest));}

/* if the remainder is a list */
        else
           ncns = _SS_append(ncns, _SS_append(item, rest));};

    return(ncns);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_QUASIQ - quasiquote macro at C level (sort of)
 *            - SS_quasiproc, name of quasiquote procedure
 *            - SS_unqproc, name of unquote procedure
 *            - SS_unqspproc,name of unquote-splicing procedure
 *            - NOTE: this crock of a version doesn't nest
 */

object *_SS_quasiq(obj, nest_level)
   object *obj;
   int nest_level;
   {object *lst, *car, *tcns, *ncns, *y;

/* handle forms like (quasiquote atom) */
    if (!SS_consp(obj))
       return(obj);

/* handle forms like (quasiquote (unqote expr)) */
    if (!SS_consp(tcns = SS_car(obj)))
       {if (SS_Unquoted(tcns))
           {ncns = SS_Unquote(obj);
            return(ncns);}
        else if (Unqsplicing(tcns))
           SS_error("MUST BE IMBEDDED IN LIST - _SS_QUASIQ", obj);};

/* look down a quasiquoted list */
    ncns = SS_null;
    y   = SS_null;
    for (lst = obj; SS_consp(lst); lst = SS_cdr(lst))
        {tcns = SS_car(lst);

/* if this element is a list */
         if (SS_consp(tcns))
            {car = SS_car(tcns);

/* is it an unquote form? */
             if (SS_Unquoted(car))
                {SS_end_cons(ncns, y, SS_Unquote(tcns));}

/* is it an unquote-splicing form? */
             else if (Unqsplicing(car))
                {ncns = SS_Splice(ncns, SS_Unquote(tcns), SS_cdr(lst), y);
                 break;}

/* any other list should be searched */
             else
                {SS_end_cons(ncns, y, _SS_quasiq(tcns, nest_level));};}

/* any non-list element should be added */
         else
            {SS_end_cons(ncns, y, tcns);};};

    return(ncns);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_QUASIQ - quasiquote macro in Scheme
 *           - SS_quasiproc, name of quasiquote procedure
 *           - SS_unqproc, name of unquote procedure
 *           - SS_unqspproc,name of unquote-splicing procedure
 */

object *SS_quasiq(obj)
   object *obj;
   {

    nest_level++;

    SS_Assign(SS_Val, _SS_quasiq(obj, nest_level));

    nest_level--;

    return(SS_Val);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_UNQUOTE - unquote macro in Scheme */

object *SS_unquote(obj)
   object *obj;
   {

    return(SS_exp_eval(obj));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_UNQ_SPL - unquote-splicing macro in Scheme */

object *SS_unq_spl(obj)
   object *obj;
   {

    return(SS_exp_eval(obj));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LAMBDA - lambda, the procedure making macro in Scheme */

object *SS_lambda(argl)
   object *argl;
   {object *lambda;

    lambda = SS_mk_procedure(argl, SS_Env);

    return(lambda);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LET - transform a let special form into a lambda application
 *        - to be handed back to eval
 */

object *SS_let(let)
   object *let;
   {object *vlpair, *vr, *vl, *lst;

    if (SS_nullobjp(let) || !SS_consp(let))
       SS_error("BAD LET FORM", let);

    SS_Save(SS_Unev);
    SS_Save(SS_Argl);
    SS_Save(SS_Fun);
    SS_Save(SS_Val);

/* transform let into a lambda form */
    SS_Assign(SS_Val, SS_cdr(let));
    SS_Assign(SS_Unev, SS_null);
    SS_Assign(SS_Argl, SS_null);
    for (lst = SS_car(let); !SS_nullobjp(lst); lst = SS_cdr(lst))
        {if (!SS_consp(vlpair = SS_car(lst)))
            {vr = vlpair;
             vl = SS_null;}
         else
            {vr = SS_car(vlpair);
             vl = SS_cadr(vlpair);};

         SS_Assign(SS_Unev, SS_mk_cons(vr, SS_Unev));
         SS_Assign(SS_Argl, SS_mk_cons(vl, SS_Argl));};

    SS_Assign(SS_Val, SS_mk_cons(SS_Unev, SS_Val));
    SS_Assign(SS_Fun, SS_mk_procedure(SS_Val, SS_Env));
    SS_Assign(SS_Exn, SS_mk_cons(SS_Fun, SS_Argl));

/* clean up the mess */
    SS_Restore(SS_Val);
    SS_Restore(SS_Fun);
    SS_Restore(SS_Argl);
    SS_Restore(SS_Unev);

    return(SS_Exn);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LETSTR - transform a let* special form into a let form
 *           - to be handed back to eval
 */

object *SS_letstr(letr)
   object *letr;
   {object *vlpair, *vr, *vl, *lst;

    if (SS_nullobjp(letr) || !SS_consp(letr))
       SS_error("BAD LET* FORM", letr);

    SS_Save(SS_This);
    SS_Save(SS_Unev);
    SS_Save(SS_Argl);
    SS_Save(SS_Fun);
    SS_Save(SS_Val);

/* transform into a functionally equivalent let form */
    SS_Assign(SS_This, SS_null);
    SS_Assign(SS_Argl, SS_null);
    SS_Assign(SS_Unev, SS_null);
    for (lst = SS_car(letr); !SS_nullobjp(lst); lst = SS_cdr(lst))
        {if (!SS_consp(vlpair = SS_car(lst)))
            {vr = vlpair;
             vl = SS_null;}
         else
            {vr = SS_car(vlpair);
             vl = SS_cadr(vlpair);};

         SS_Assign(SS_Val,
                   SS_mk_cons(SS_setproc,
                              SS_mk_cons(vr, SS_mk_cons(vl, SS_null))));
         SS_end_cons_macro(SS_Argl, SS_This, SS_Val);
         SS_Assign(SS_Unev, SS_mk_cons(vr, SS_Unev));};

/* complete the transformation */
    SS_Assign(SS_Fun, SS_mk_cons(SS_Unev,
                                 _SS_append(SS_Argl, SS_cdr(letr))));

/* process the let form */
    SS_Assign(SS_Exn, SS_let(SS_Fun));

/* clean up the mess */
    SS_Restore(SS_Val);
    SS_Restore(SS_Fun);
    SS_Restore(SS_Argl);
    SS_Restore(SS_Unev);
    SS_Restore(SS_This);

    return(SS_Exn);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LST_MAP - prepare the args to map or for-each for procedure calls
 *            - cdr down the ARGL's
 *            - replace the ARGL with the cdr'd version
 *            - return the ARGS for the application
 */

object *SS_lst_map(argl, Ex_flag)
   object *argl;
   int *Ex_flag;
   {object *args, *arg_nxt, *rest, *rest_nxt, *lst;

    for (args = SS_null, rest = SS_null; SS_consp(argl); argl = SS_cdr(argl))
        {lst = SS_car(argl);

/* taking the car of each arg LST make up the list of ARGS for proc */
         SS_end_cons(args, arg_nxt, SS_car(lst));

/* cons up a list with the REST of the argument lists */
         if (!SS_nullobjp(lst = SS_cdr(lst)))
            {SS_end_cons(rest, rest_nxt, lst);};

/* if we're at the end of any arg LST signal to exit the loop */
         if (!SS_consp(lst))
            *Ex_flag = TRUE;};

/* if there are no more ARG Lists reset ARGL to the REST of the arguments */
    return(SS_mk_cons(args, rest));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_MAP - map for Scheme */

object *SS_map(obj)
   object *obj;
   {object *proc, *argl, *expr, *args, *vl, *ret, *ret_nxt;
    int Ex_flag;

    proc = SS_car(obj);
    argl = SS_cdr(obj);
    if (!SS_consp(argl))
       return(proc);

    SS_MARK(argl);
    expr = SS_null;
    vl   = SS_null;
    args = SS_null;
    ret  = SS_null;
    for (Ex_flag = FALSE; !Ex_flag; )
        {SS_Assign(vl, SS_lst_map(argl, &Ex_flag));
         if (SS_consp(SS_caar(vl)))
            {SS_Assign(args, SS_mk_cons(SS_quoteproc, SS_car(vl)));
             SS_Assign(expr, SS_mk_cons(proc, SS_mk_cons(args, SS_null)));}
         else
            {SS_Assign(args, SS_car(vl));
             SS_Assign(expr, SS_mk_cons(proc, args));};
         SS_Assign(argl, SS_cdr(vl));
         SS_Save(SS_Env);
         SS_end_cons(ret, ret_nxt, SS_exp_eval(expr));
         SS_Restore(SS_Env);};

/* clean up the mess */
    SS_GC(expr);
    SS_GC(argl);
    SS_GC(args);
    SS_GC(vl);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_FOREACH - for-each for Scheme */

object *SS_foreach(obj)
   object *obj;
   {object *proc, *argl, *expr, *args, *vl;
    int Ex_flag;

    proc = SS_car(obj);
    argl = SS_cdr(obj);
    if (!SS_consp(argl))
       return(proc);

    SS_MARK(argl);
    expr = SS_null;
    vl   = SS_null;
    args = SS_null;
    for (Ex_flag = FALSE; !Ex_flag; )
        {SS_Assign(vl, SS_lst_map(argl, &Ex_flag));
         if (SS_consp(SS_caar(vl)))
            {SS_Assign(args, SS_mk_cons(SS_quoteproc, SS_car(vl)));
             SS_Assign(expr, SS_mk_cons(proc, SS_mk_cons(args, SS_null)));}
         else
            {SS_Assign(args, SS_car(vl));
             SS_Assign(expr, SS_mk_cons(proc, args));};
         SS_Assign(argl, SS_cdr(vl));
         SS_Save(SS_Env);
         SS_exp_eval(expr);
         SS_Restore(SS_Env);};

/* clean up the mess */
    SS_GC(expr);
    SS_GC(argl);
    SS_GC(args);
    SS_GC(vl);

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_NOT - not for Scheme */

object *SS_not(obj)
   object *obj;
   {

    return((SS_true(obj)) ? SS_f : SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LIST - list in Scheme */

object *SS_list(argl)
   object *argl;
   {

    return(argl);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_TRACE - set the trace field in the procedure structs to TRUE */

object *SS_trace(argl)
   object *argl;
   {object *lst, *car;

    lst = argl;
    while ((car = SS_car(lst)) != NULL)
       {if (SS_procedurep(car))
           SS_PROCEDURE_TRACEDP(car) = TRUE;
        if (SS_nullobjp(lst = SS_cdr(lst)))
           break;};

    return(argl);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_UNTRACE - set the trace field in the procedure structs to FALSE */

object *SS_untrace(argl)
   object *argl;
   {object *lst, *car;

    lst = argl;
    while ((car = SS_car(lst)) != NULL)
       {if (SS_procedurep(car))
           SS_PROCEDURE_TRACEDP(car) = FALSE;
        if (SS_nullobjp(lst = SS_cdr(lst)))
           break;};

    return(argl);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_BGN_TRACE - start a trace if the procedure is to be traced */

void SS_bgn_trace(pfun, pargl)
   object *pfun, *pargl;
   {

    switch (SS_PROCEDURE_TYPE(pfun))
       {case SS_PROC     :
        case SS_EE_MACRO :
        case SS_PR_PROC  : if (SS_tracedp(pfun))
                              {PRINT(SS_OUTSTREAM(SS_outdev),
                                     "Entering procedure %s with:\n  ",
                                     SS_PROCEDURE_NAME(pfun));
                               _SS_print(pargl, "", "\n", SS_outdev);
                               SS_Assign(SS_continue[SS_cont_ptr].signal,
                                         pfun);};
                           break;
        case SS_BEGIN    :
        case SS_COND     :
        case SS_IF       :
        case SS_AND      :
        case SS_OR       : 
        case SS_MACRO    :
        case SS_UE_MACRO :
        case SS_UR_MACRO : if (SS_tracedp(pfun))
                              {PRINT(SS_OUTSTREAM(SS_outdev),
                                     "Entering macro %s with:\n  ",
                                     SS_PROCEDURE_NAME(pfun));
                               _SS_print(pargl, "", "\n", SS_outdev);
                               SS_Assign(SS_continue[SS_cont_ptr].signal,
                                         pfun);};
        default          : break;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_END_TRACE - check a continuation on its return for a traced procedure */

void SS_end_trace()
   {object *pfun;

    pfun = SS_continue[SS_cont_ptr].signal;
    if (SS_procedurep(pfun))
       {switch (SS_PROCEDURE_TYPE(pfun))
            {case SS_PROC     :
             case SS_EE_MACRO :
             case SS_PR_PROC  : if (SS_tracedp(pfun))
                                   {PRINT(SS_OUTSTREAM(SS_outdev),
                                          "Leaving procedure %s with:\n  ",
                                          SS_PROCEDURE_NAME(pfun));
                                    _SS_print(SS_Val, "", "\n",
                                              SS_outdev);};
                                break;
             case SS_BEGIN    :
             case SS_COND     :
             case SS_IF       :
             case SS_AND      :
             case SS_OR       :
             case SS_MACRO    :
             case SS_UE_MACRO :
             case SS_UR_MACRO : if (SS_tracedp(pfun))
                                   {PRINT(SS_OUTSTREAM(SS_outdev),
                                          "Leaving macro %s with:\n  ",
                                          SS_PROCEDURE_NAME(pfun));
                                    _SS_print(SS_Val, "", "\n", SS_outdev);};
             default          : break;};

        SS_Assign(SS_continue[SS_cont_ptr].signal, SS_null);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CATCH - the entry part of call-with-current-continuation */

object *SS_catch(obj)
   object *obj;
   {object *escape, *ret, *lst;

    escape = SS_mk_esc_proc(SS_cont_ptr, SS_stack_ptr, SS_errlev, PROC_OBJ);
    lst    = SS_make_list(SS_OBJECT_I, obj,
			  SS_OBJECT_I, escape,
			  0);

/* Use the fact that SS_Assign(SS_Exn, obj) is done in SS_eval to provide the
 * only reference to lst so that GC is done properly
 */
    ret = SS_exp_eval(lst);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CATCH_ERR - the entry part of err-catch */

object *SS_catch_err(argl)
   object *argl;
   {object *err_proc, *proc_call, *err_ev, *ret;
    object *esc;
    static PFVoid print_err_hook;

    print_err_hook = SS_print_err_msg_hook;

    err_proc  = SS_null;
    proc_call = SS_null;
    SS_args(argl,
	    SS_OBJECT_I, &err_proc,
	    SS_OBJECT_I, &proc_call,
	    0);

/* set the stage for error handling at the SCHEME level */
    SS_Assign(SS_err_state, SS_null);
    SS_print_err_msg_hook = NULL;

    SS_cont_ptr++;
    SS_push_err(FALSE, ERR_OBJ);
    switch (setjmp(SS_continue[SS_cont_ptr].cont))
       {case ABORT     : SS_print_err_msg_hook = print_err_hook;

	                 err_ev = SS_mk_cons(err_proc, SS_err_state);
	                 ret    = SS_exp_eval(err_ev);
                         break;

        case RETURN_OK : ret = SS_Val;
                         break;

        default        : ret = SS_exp_eval(proc_call);

        case ERR_FREE  : esc = SS_pop_err(SS_errlev - 1, FALSE);
                         SS_GC(esc);};

    SS_cont_ptr--;

    SS_print_err_msg_hook = print_err_hook;

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_TIME - return the time from Scheme as
 *         - (yy mm dd hh mm ss) all are ints
 */

object *SS_time()
   {struct tm *loct;
    time_t syst;

    syst = time(NULL);
    loct = localtime(&syst);    

/* make the month right */
    loct->tm_mon++;

    return(SS_make_list(SC_INTEGER_I, &loct->tm_year,
                        SC_INTEGER_I, &loct->tm_mon,
                        SC_INTEGER_I, &loct->tm_mday,
                        SC_INTEGER_I, &loct->tm_hour,
                        SC_INTEGER_I, &loct->tm_min,
                        SC_INTEGER_I, &loct->tm_sec,
                        0));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
