/*
 * GSSFTS.C - test the surface drawing routines in PGS
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

#define N_POINTS 10

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* DRAW_SET - draw a complete set of plots */

static void draw_set(SCR_dev, PS_mdev, CGM_mdev, PS_cdev, CGM_cdev,
		     rz, rs, ext, rx, ry,
		     n_pts, xmn, xmx, ymn, ymx, theta, phi,
		     width, color, style, type, maxes, alist,
		     fast)
   PG_device *SCR_dev, *PS_mdev, *CGM_mdev, *PS_cdev, *CGM_cdev;
   REAL *rz, *rs, *ext, *rx, *ry;
   int n_pts;
   double xmn, xmx, ymn, ymx, theta, phi, width;
   int color, style, type;
   int *maxes;
   pcons *alist;
   int fast;
   {

    PG_draw_surface(SCR_dev, rz, rs, ext, rx, ry,
		    n_pts,
		    xmn, xmx, ymn, ymx, theta, phi, 0.0, width, color, style,
		    type, "Test Data",
		    PM_LR_S, maxes, alist);

    if (!fast)
       return;

    PRINT(STDOUT, "Monochrome PS ... ");
    PG_draw_surface(PS_mdev, rz, rs, ext, rx, ry,
		    n_pts,
		    xmn, xmx, ymn, ymx, theta, phi, 0.0, width, color, style,
		    type, "Test Data",
		    PM_LR_S, maxes, alist);

    PRINT(STDOUT, "Monochrome CGM ... ");
    PG_draw_surface(CGM_mdev, rz, rs, ext, rx, ry,
		    n_pts,
		    xmn, xmx, ymn, ymx, theta, phi, 0.0, width, color, style,
		    type, "Test Data",
		    PM_LR_S, maxes, alist);

    PRINT(STDOUT, "Color PS ... ");
    PG_draw_surface(PS_cdev, rz, rs, ext, rx, ry,
		    n_pts,
		    xmn, xmx, ymn, ymx, theta, phi, 0.0, width, color, style,
		    type, "Test Data",
		    PM_LR_S, maxes, alist);

    PRINT(STDOUT, "Color CGM ... ");
    PG_draw_surface(CGM_cdev, rz, rs, ext, rx, ry,
		    n_pts,
		    xmn, xmx, ymn, ymx, theta, phi, 0.0, width, color, style,
		    type, "Test Data",
		    PM_LR_S, maxes, alist);

    PRINT(STDOUT, "done\n");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PRINT_HELP - print a help message */

static void print_help()
   {PRINT(STDOUT, "\nGSSFTS - test the surface plotting in PGS\n");
    PRINT(STDOUT, "\n");

    PRINT(STDOUT, "Usage: gssfts [-d #] [-p #] [-h] [-z #]\n");
    PRINT(STDOUT, "\n");

    PRINT(STDOUT, "       -d  delta phi in degrees for sequence\n");
    PRINT(STDOUT, "       -f  do hardcopy tests (for fast machines)\n");
    PRINT(STDOUT, "       -h  Print this help message and exit\n");
    PRINT(STDOUT, "       -p  palette 0 - spectrum, 1 - rainbow, 2 - bw\n");
    PRINT(STDOUT, "       -z  Use the specified number of zones on a side\n");

    PRINT(STDOUT, "\n");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char **argv;
   {int i, k, l, nt;
    int maxes[2], X_max, Y_max, n_pts, use_color, type, palette;
    double x, y, dx, dy, theta, phi, dp;
    char t[MAXLINE], *token, *emap;
    PG_device *SCR_dev, *PS_mdev, *CGM_mdev, *PS_cdev, *CGM_cdev;
    REAL *rx, *ry, *rz, *rs, *px, *py, *pz, *ps, *ext;
    pcons *alist;
    char *palettes[] = {"spectrum", "rainbow", "bw"};

    X_max     = N_POINTS;
    Y_max     = N_POINTS;
    palette   = 0;
    use_color = FALSE;
    type      = PLOT_WIRE_MESH;
    dp        = 0.0;
    nt        = 1;
    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'c' :
		      use_color = TRUE;
		      break;
                 case 'd' :
		      dp = ATOF(argv[++i]);
		      break;
                 case 'f' :
		      fast = TRUE;
		      break;
                 case 'h' :
		      print_help();
		      return(1);
                 case 'p' :
		      palette = atoi(argv[++i]);
		      break;
                 case 's' :
		      type = PLOT_SURFACE;
		      break;
                 case 't' :
		      nt = atoi(argv[++i]);
		      break;
                 case 'w' :
		      type = PLOT_WIRE_MESH;
		      break;
                 case 'z' :
		      X_max = Y_max = atoi(argv[++i]);
		      break;};}

         else
            break;};

    SC_init_threads(nt, NULL);

    maxes[0] = X_max;
    maxes[1] = Y_max;
    n_pts    = X_max*Y_max;

    emap = FMAKE_N(char, n_pts, "GSSFTS.C:emap");
    memset(emap, 1, n_pts);
    alist = SC_add_alist(NULL, "EXISTENCE", SC_STRING_S, (byte *) emap);

    PG_open_console("GSSFTS", "MONOCHROME", 1,
                    0.55, 0.1, 0.4, 0.8);

    if (use_color)
       SCR_dev = PG_make_device("WINDOW", "COLOR", "PGS Surface Test");
    else
       SCR_dev = PG_make_device("WINDOW", "MONOCHROME", "PGS Surface Test");
/*    PG_open_device(SCR_dev, 0.1, 0.1, 0.02, 0.02); */
    PG_open_device(SCR_dev, 0.1, 0.1, 0.4, 0.4);

    if (type == PLOT_SURFACE)
       PG_set_palette(SCR_dev, palettes[palette]);

    if (fast)
       {PS_cdev  = PG_make_device("PS", "COLOR", "gssfts-c");
	CGM_cdev = PG_make_device("CGM", "COLOR", "gssfts-c");
	PS_mdev  = PG_make_device("PS", "MONOCHROME", "gssfts-m");
	CGM_mdev = PG_make_device("CGM", "MONOCHROME", "gssfts-m");

	PG_open_device(PS_cdev, 0.0, 0.0, 0.0, 0.0);
	PG_open_device(CGM_cdev, 0.0, 0.0, 0.0, 0.0);
	PG_open_device(PS_mdev, 0.0, 0.0, 0.0, 0.0);
	PG_open_device(CGM_mdev, 0.0, 0.0, 0.0, 0.0);

	if (type == PLOT_SURFACE)
	   {PG_set_palette(PS_mdev, palettes[palette]);
	    PG_set_palette(CGM_mdev, palettes[palette]);
	    PG_set_palette(PS_cdev, palettes[palette]);
	    PG_set_palette(CGM_cdev, palettes[palette]);};};

    rx = px = FMAKE_N(REAL, n_pts, "GSSFTS.C:rx");
    ry = py = FMAKE_N(REAL, n_pts, "GSSFTS.C:ry");
    rz = pz = FMAKE_N(REAL, n_pts, "GSSFTS.C:rz");

    if (type == PLOT_SURFACE)
       rs = ps = FMAKE_N(REAL, n_pts, "GSSFTS.C:rs");
    else
       rs = ps = pz;

    ext = FMAKE_N(REAL, 4, "GSSFTS.C:ext");
    ext[0] = -1;
    ext[1] =  1;
    ext[2] = -1;
    ext[3] =  1;

/* draw the first image */
    dx = 2.0*PI/((double) (X_max - 1));
    dy = 2.0*PI/((double) (Y_max - 1));
    for (l = 0; l < Y_max; l++)
        {for (k = 0; k < X_max; k++)
             {*px++ = x = ((double) k)*dx;
              *py++ = y = ((double) l)*dy;
              *pz++ = cos(y);
	      if (type == PLOT_SURFACE)
                 *ps++ = sin(x);};};

    if (dp == 0.0)
       {while (TRUE)
           {char *s;

	    PRINT(STDOUT, "Viewing Angle: ");
            GETLN(t, MAXLINE, stdin);

            if ((token = SC_strtok(t, " ,", s)) == NULL)
               break;
            theta = DEG_RAD*ATOF(token);

            if ((token = SC_strtok(NULL, " ,", s)) == NULL)
               break;
            phi = DEG_RAD*ATOF(token);

            draw_set(SCR_dev, PS_mdev, CGM_mdev, PS_cdev, CGM_cdev,
		     rz, rs, ext, rx, ry,
		     n_pts,
		     0.0, 2.0*PI, 0.0, 2.0*PI,
		     theta, phi,
		     0.0, SCR_dev->BLUE, SOLID,
		     type, maxes, alist,
		     fast);};}

    else
       {for (phi = 0.0; phi <= 90.0; phi += dp)
            {draw_set(SCR_dev, PS_mdev, CGM_mdev, PS_cdev, CGM_cdev,
		      rz, rs, ext, rx, ry,
		      n_pts,
		      0.0, 2.0*PI, 0.0, 2.0*PI,
		      0.0, DEG_RAD*phi,
		      0.0, SCR_dev->BLUE, SOLID,
		      type, maxes, alist,
		      fast);};};

    PG_close_device(SCR_dev);

    if (fast)
       {PG_close_device(PS_cdev);
	PG_close_device(CGM_cdev);
	PG_close_device(PS_mdev);
	PG_close_device(CGM_mdev);};

    SFREE(emap);

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
