/*
 * SCMD.C - command processors for S
 *
 */

#include "s.h"

HASHTAB
 *srctab;

PDBfile
 *pdsf;

double
 conversion_s;

char
 in_deck[MAXLINE],                                /* global input deck name */
 *PAN_SOURCE = NULL,
 varname[MAXLINE];

static double
 *data;

static int
 count,
 var_sz;

/*--------------------------------------------------------------------------*/

/*                                 HANDLERS                                 */

/*--------------------------------------------------------------------------*/

/* SRC_ZARGS - handler for zero argument commands */

static void SRC_zargs(cp)
   PA_command *cp;
   {(*(cp->proc))();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SRC_STRARG - handler for single string argument commands */

static void SRC_strarg(cp)
   PA_command *cp;
   {(*(cp->proc))(PA_get_field("FIELD", "SRC_STRARG", OPTL));

    return;}

/*--------------------------------------------------------------------------*/

/*                              MEMORY MANAGEMENT                           */

/*--------------------------------------------------------------------------*/

/* NEXT_NAME - make a new variable name */

char *next_name()
   {static int n = 0;
    char *s;

    s = FMAKE_N(char, 10, "NEXT_NAME:s");
    sprintf(s, "var%d", n++);

    return(s);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MK_SOURCE_RECORD - make a new source_record and return a pointer to it */

static source_record *mk_source_record(time, data)
   double time, *data;
   {source_record *sp;

    sp       = FMAKE(source_record, "MK_SOURCE_RECORD:sp");
    sp->time = time;
    sp->name = next_name();
    sp->data = data;

    return(sp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MK_TIME_LIST - make a time_list and return a pointer to it */

static time_list *mk_time_list()
   {time_list *tp;

    tp         = FMAKE(time_list, "MK_TIME_LIST:tp");
    tp->list   = NULL;
    tp->length = 0;

    return(tp);}

/*--------------------------------------------------------------------------*/

/*                                    I/O                                   */

/*--------------------------------------------------------------------------*/

/* WRITE_VAR - write out source file variables
 */

static int write_var(pdsf, name, tp, dp, sz)
   PDBfile *pdsf;
   char *name;
   double *tp, **dp;
   int sz;
   {int i, szd;
    long ind[2];
    double *vdata;
    char svname[MAXLINE], title[MAXLINE];
    static int count = 0;

    N_Variables++;

    ind[0] = 0L;

/* write out the string header for this variable
 * header format :
 *           <var-name>|<num-times>|<time-array-name>
 */
    sprintf(title, "src%d", count);
    sprintf(svname, "%s|%d|st%d", name, sz, count);
    ind[1] = strlen(svname);
    PD_write_alt(pdsf, title, "char", svname, 1, ind);

/* write out the data arrays one at a time */

    szd = SC_arrlen(*dp)/sizeof(double);
    for (i = 0; i < sz; i++)
        {sprintf(svname, "%s:%d", title, i);
         vdata  = dp[i];
         ind[1] = szd - 1;
         PD_write_alt(pdsf, svname, "double", vdata, 1, ind);};

/* now write out the time array */
    sprintf(title, "st%d", count);
    ind[1] = sz - 1;
    PD_write_alt(pdsf, title, "double", tp, 1, ind);

/* increment the variable counter */
    count++;

    return(TRUE);}

/*--------------------------------------------------------------------------*/

/*                               COMMANDS                                   */

/*--------------------------------------------------------------------------*/

/* MAKEH - write the variables out, write out the number of source
 *       - variables, and close the PDB source file
 */

static void makeh()
   {int i, j, l, sz, change, N_var;
    double t1, t2, *tt, **td, *pd, *time, **data;
    hashel **tab, *hp;
    source_record *sp;
    time_list *tp;
    pcons *pp, *pn;

/* order the times for each variable in srctab */
    sz    = srctab->size;
    tab   = srctab->table;
    N_var = 0;
    for (i = 0; i < sz; i++)
        for (hp = tab[i]; hp != NULL; hp = hp->next)
            {tp = (time_list *) (hp->def);
             l  = tp->length;

/* copy the list into arrays */
             tt = time = FMAKE_N(double, l, "MAKEH:tt");
             td = data = FMAKE_N(double *, l, "MAKEH:td");
             for (pp = tp->list; pp != NULL; pp = pn)
                 {sp = (source_record *) pp->car;
                  *(tt++) = sp->time;
                  *(td++) = sp->data;
                  pn = (pcons *) pp->cdr;
                  SFREE(sp);
                  SFREE(pp);};

/* sort the arrays according to the times */
             change = TRUE;
             while (change)
                {change = FALSE;
                 for (j = 1; j < l; j++)
                     {t1 = time[j-1];
                      t2 = time[j];
                      if (t2 < t1)
                         {pd        = data[j-1];
                          data[j-1] = data[j];
                          data[j]   = pd;
                          time[j]   = t1;
                          time[j-1] = t2;
                          change    = TRUE;};};};

/* write the variable and source_record array out */
             write_var(pdsf, hp->name, time, data, l);
             N_var++;

/* release the temporary storage for this variable */
             SFREE_N(time, l);
             SFREE_N(data, l);};

/* finish up */
    PD_write(pdsf, "N_Variables", "integer", &N_var);
    PD_close(pdsf);
    pdsf = NULL;    

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* RECORD_ENTRY - record a time entry in the list of times for the given
 *              - variable making an entry in srctab if needed
 *              - return the name under which the data will be installed
 *              - in the PDB source file
 */

static void record_entry(name, time, data)
   char *name;
   double time, *data;
   {hashel *hp;
    pcons *fp;
    source_record *sp;
    time_list *tp;

    strcpy(varname, name);

/* lookup the variable and install it if this is the first time */
    hp = SC_lookup(name, srctab);
    if (hp == NULL)
       {tp = mk_time_list();
        hp = SC_install(name, tp, PAN_SOURCE, srctab);};

/* cons the new time onto the list of times */
    tp       = (time_list *) (hp->def);
    sp       = mk_source_record(time, data);
    fp       = SC_mk_pcons("source record *", (byte *) sp,
			   "time_list *", (byte *) (tp->list));
    tp->list = fp;
    (tp->length)++;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* VARH - handler for data base variable based commands
 *      - Format:
 *      -         <var> tmax size i1 ...
 */

static void varh(pp)
   PA_variable *pp;
   {char *s, *pname, bf[MAXLINE];
    int first, size;
    double tmax;

    pname        = PA_VARIABLE_NAME(pp);
    conversion_s = 1.0/PA_VARIABLE_EXT_UNIT(pp);

/* get the information off the command line */
    tmax = SC_stof(PA_get_field("TMAX", "VARIABLE", REQU));
    size = SC_stoi(PA_get_field("SIZE", "VARIABLE", REQU));

/* allocate storage for the data */
    data   = FMAKE_N(double, size, "VARH:data");
    count  = 0;
    var_sz = size;

/* cat the variable name and the indexes together to make a unique label */
    first = TRUE;
    strcpy(bf, pname);
    while ((s = PA_get_field("INDEX", "VARIABLE", OPTL)) != NULL)
       {if (!first)
           strcat(bf, ",");
        else
           strcat(bf, "(");
        strcat(bf, s);
        first = FALSE;};
    if (!first)
       strcat(bf, ")");

/* record this entry */
    record_entry(bf, tmax, data);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SH - default handler for data values */

static void sh(t)
   char *t;
   {char *s;

/* save the first token which is passed in as an argument */
    count++;
    *(data++) = conversion_s*SC_stof(t);

/* read the remaining tokens from the input line */
    while ((s = PA_get_field("SPECIFICATION", "VALUE", OPTL)) != NULL)
       {count++;
        PA_ERR(!SC_numstrp(s), "BAD NUMERIC FIELD - %s", s);
        *(data++) = conversion_s*SC_stof(s);}

/* count should not be greater than the variable size */
    PA_ERR((count > var_sz),
           "TOO MANY VALUES FOR VARIABLE % s - %d vs %d",
           varname, count, var_sz);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* READH - handle the read command for S */

void readh(str)
   char *str;
   {char *token, s[MAXLINE];
    PA_command *cp;
    hashel *hp;
    PA_variable *pp;
    FILE *strm;

    strcpy(in_deck, str);
    strm = fopen(str, "r");
    PA_ERR((strm == NULL),
           "COULDN'T OPEN FILE %s", str);

/* dispatch on commands from the deck */
    while (TRUE)
       {if (GETLN(s, MAXLINE, strm) == NULL)
           {fclose(strm);
            break;};

        if (SC_blankp(s, "c;#"))
           continue;

        token = SC_strtok(s, " \n\r\t/(", PA_strtok_p);
        if (token != NULL)
           {hp = SC_lookup(token, PA_commands);
            if (hp != NULL)
               {conversion_s = 1.0;
                cp = (PA_command *) hp->def;
                (*(cp->handler))(cp);}

            else if ((hp = SC_lookup(token, PA_variable_tab)) != NULL)
               {pp = (PA_variable *) hp->def;
                varh(pp);}

            else if (SC_numstrp(token))
               sh(token);

            else
               PA_WARN(TRUE,"UNRECOGNIZED TOKEN %s IN FILE %s",
                       token, str);};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* CLEAR_SYS - re-initialize the system in preparation for
 *           - a new source deck
 */

static void clear_sys()
   {if (pdsf != NULL)
       {PD_close(pdsf);
        pdsf = NULL;}

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* DONEH - gracefully leave S */

static void doneh()
   {clear_sys();

    longjmp(SC_top_lev, ERR_FREE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* INST_S - install the commands for S */
 
void inst_s()
   {PAN_COMMAND = SC_strsave("command");

    PA_inst_c("end", NULL, FALSE, 0, doneh, SRC_zargs);
    PA_inst_c("clear", NULL, FALSE, 0, clear_sys, SRC_zargs);
    PA_inst_c("read", NULL, A_CHAR, 1, readh, SRC_strarg);
    PA_inst_c("make", NULL, FALSE, 0, makeh, SRC_zargs);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* S_GEN - handle variable names as commands */

void S_gen(s)
   char *s;
   {PA_variable *pp;
    hashel *hp;

    hp = SC_lookup(s, PA_variable_tab);
    if (hp != NULL)
       {pp = (PA_variable *) hp->def;
        varh(pp);}

    else if (SC_numstrp(s))
       sh(s);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
